# coding: utf-8
"""
<copyright company="Aspose" file="Rangepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Range(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'column_count' : 'int',
        'column_width' : 'float',
        'first_column' : 'int',
        'first_row' : 'int',
        'name' : 'str',
        'refers_to' : 'str',
        'row_count' : 'int',
        'row_height' : 'float',
        'worksheet' : 'str'
    }

    attribute_map = {
        'column_count' : 'ColumnCount' ,
        'column_width' : 'ColumnWidth' ,
        'first_column' : 'FirstColumn' ,
        'first_row' : 'FirstRow' ,
        'name' : 'Name' ,
        'refers_to' : 'RefersTo' ,
        'row_count' : 'RowCount' ,
        'row_height' : 'RowHeight' ,
        'worksheet' : 'Worksheet' 
    }

    @staticmethod
    def get_swagger_types():
        return Range.swagger_types

    @staticmethod
    def get_attribute_map():
        return Range.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,column_count=None ,column_width=None ,first_column=None ,first_row=None ,name=None ,refers_to=None ,row_count=None ,row_height=None ,worksheet=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Range - a model defined in Swagger
        """
        self.container['column_count'] = None 
        self.container['column_width'] = None 
        self.container['first_column'] = None 
        self.container['first_row'] = None 
        self.container['name'] = None 
        self.container['refers_to'] = None 
        self.container['row_count'] = None 
        self.container['row_height'] = None 
        self.container['worksheet'] = None 
        params = locals()
        self.column_count = column_count
        if 'column_count' in params:
            self.column_count = params["column_count"]


             
        self.column_width = column_width
        if 'column_width' in params:
            self.column_width = params["column_width"]


             
        self.first_column = first_column
        if 'first_column' in params:
            self.first_column = params["first_column"]


             
        self.first_row = first_row
        if 'first_row' in params:
            self.first_row = params["first_row"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.refers_to = refers_to
        if 'refers_to' in params:
            self.refers_to = params["refers_to"]


             
        self.row_count = row_count
        if 'row_count' in params:
            self.row_count = params["row_count"]


             
        self.row_height = row_height
        if 'row_height' in params:
            self.row_height = params["row_height"]


             
        self.worksheet = worksheet
        if 'worksheet' in params:
            self.worksheet = params["worksheet"]


             

    @property
    def column_count(self):
        return self.container['column_count']

    @column_count.setter
    def column_count(self, column_count):
        self.container['column_count'] = column_count 
    @property
    def column_width(self):
        return self.container['column_width']

    @column_width.setter
    def column_width(self, column_width):
        self.container['column_width'] = column_width 
    @property
    def first_column(self):
        return self.container['first_column']

    @first_column.setter
    def first_column(self, first_column):
        self.container['first_column'] = first_column 
    @property
    def first_row(self):
        return self.container['first_row']

    @first_row.setter
    def first_row(self, first_row):
        self.container['first_row'] = first_row 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def refers_to(self):
        return self.container['refers_to']

    @refers_to.setter
    def refers_to(self, refers_to):
        self.container['refers_to'] = refers_to 
    @property
    def row_count(self):
        return self.container['row_count']

    @row_count.setter
    def row_count(self, row_count):
        self.container['row_count'] = row_count 
    @property
    def row_height(self):
        return self.container['row_height']

    @row_height.setter
    def row_height(self, row_height):
        self.container['row_height'] = row_height 
    @property
    def worksheet(self):
        return self.container['worksheet']

    @worksheet.setter
    def worksheet(self, worksheet):
        self.container['worksheet'] = worksheet 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Range):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    