# coding: utf-8
"""
<copyright company="Aspose" file="Protectionpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Protection(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'allow_deleting_column' : 'bool',
        'allow_deleting_row' : 'bool',
        'allow_filtering' : 'bool',
        'allow_formatting_cell' : 'bool',
        'allow_formatting_column' : 'bool',
        'allow_formatting_row' : 'bool',
        'allow_inserting_column' : 'bool',
        'allow_inserting_hyperlink' : 'bool',
        'allow_inserting_row' : 'bool',
        'allow_sorting' : 'bool',
        'allow_using_pivot_table' : 'bool',
        'allow_editing_content' : 'bool',
        'allow_editing_object' : 'bool',
        'allow_editing_scenario' : 'bool',
        'password' : 'str',
        'allow_selecting_locked_cell' : 'bool',
        'allow_selecting_unlocked_cell' : 'bool'
    }

    attribute_map = {
        'allow_deleting_column' : 'AllowDeletingColumn' ,
        'allow_deleting_row' : 'AllowDeletingRow' ,
        'allow_filtering' : 'AllowFiltering' ,
        'allow_formatting_cell' : 'AllowFormattingCell' ,
        'allow_formatting_column' : 'AllowFormattingColumn' ,
        'allow_formatting_row' : 'AllowFormattingRow' ,
        'allow_inserting_column' : 'AllowInsertingColumn' ,
        'allow_inserting_hyperlink' : 'AllowInsertingHyperlink' ,
        'allow_inserting_row' : 'AllowInsertingRow' ,
        'allow_sorting' : 'AllowSorting' ,
        'allow_using_pivot_table' : 'AllowUsingPivotTable' ,
        'allow_editing_content' : 'AllowEditingContent' ,
        'allow_editing_object' : 'AllowEditingObject' ,
        'allow_editing_scenario' : 'AllowEditingScenario' ,
        'password' : 'Password' ,
        'allow_selecting_locked_cell' : 'AllowSelectingLockedCell' ,
        'allow_selecting_unlocked_cell' : 'AllowSelectingUnlockedCell' 
    }

    @staticmethod
    def get_swagger_types():
        return Protection.swagger_types

    @staticmethod
    def get_attribute_map():
        return Protection.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,allow_deleting_column=None ,allow_deleting_row=None ,allow_filtering=None ,allow_formatting_cell=None ,allow_formatting_column=None ,allow_formatting_row=None ,allow_inserting_column=None ,allow_inserting_hyperlink=None ,allow_inserting_row=None ,allow_sorting=None ,allow_using_pivot_table=None ,allow_editing_content=None ,allow_editing_object=None ,allow_editing_scenario=None ,password=None ,allow_selecting_locked_cell=None ,allow_selecting_unlocked_cell=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Protection - a model defined in Swagger
        """
        self.container['allow_deleting_column'] = None 
        self.container['allow_deleting_row'] = None 
        self.container['allow_filtering'] = None 
        self.container['allow_formatting_cell'] = None 
        self.container['allow_formatting_column'] = None 
        self.container['allow_formatting_row'] = None 
        self.container['allow_inserting_column'] = None 
        self.container['allow_inserting_hyperlink'] = None 
        self.container['allow_inserting_row'] = None 
        self.container['allow_sorting'] = None 
        self.container['allow_using_pivot_table'] = None 
        self.container['allow_editing_content'] = None 
        self.container['allow_editing_object'] = None 
        self.container['allow_editing_scenario'] = None 
        self.container['password'] = None 
        self.container['allow_selecting_locked_cell'] = None 
        self.container['allow_selecting_unlocked_cell'] = None 
        params = locals()
        self.allow_deleting_column = allow_deleting_column
        if 'allow_deleting_column' in params:
            self.allow_deleting_column = params["allow_deleting_column"]


             
        self.allow_deleting_row = allow_deleting_row
        if 'allow_deleting_row' in params:
            self.allow_deleting_row = params["allow_deleting_row"]


             
        self.allow_filtering = allow_filtering
        if 'allow_filtering' in params:
            self.allow_filtering = params["allow_filtering"]


             
        self.allow_formatting_cell = allow_formatting_cell
        if 'allow_formatting_cell' in params:
            self.allow_formatting_cell = params["allow_formatting_cell"]


             
        self.allow_formatting_column = allow_formatting_column
        if 'allow_formatting_column' in params:
            self.allow_formatting_column = params["allow_formatting_column"]


             
        self.allow_formatting_row = allow_formatting_row
        if 'allow_formatting_row' in params:
            self.allow_formatting_row = params["allow_formatting_row"]


             
        self.allow_inserting_column = allow_inserting_column
        if 'allow_inserting_column' in params:
            self.allow_inserting_column = params["allow_inserting_column"]


             
        self.allow_inserting_hyperlink = allow_inserting_hyperlink
        if 'allow_inserting_hyperlink' in params:
            self.allow_inserting_hyperlink = params["allow_inserting_hyperlink"]


             
        self.allow_inserting_row = allow_inserting_row
        if 'allow_inserting_row' in params:
            self.allow_inserting_row = params["allow_inserting_row"]


             
        self.allow_sorting = allow_sorting
        if 'allow_sorting' in params:
            self.allow_sorting = params["allow_sorting"]


             
        self.allow_using_pivot_table = allow_using_pivot_table
        if 'allow_using_pivot_table' in params:
            self.allow_using_pivot_table = params["allow_using_pivot_table"]


             
        self.allow_editing_content = allow_editing_content
        if 'allow_editing_content' in params:
            self.allow_editing_content = params["allow_editing_content"]


             
        self.allow_editing_object = allow_editing_object
        if 'allow_editing_object' in params:
            self.allow_editing_object = params["allow_editing_object"]


             
        self.allow_editing_scenario = allow_editing_scenario
        if 'allow_editing_scenario' in params:
            self.allow_editing_scenario = params["allow_editing_scenario"]


             
        self.password = password
        if 'password' in params:
            self.password = params["password"]


             
        self.allow_selecting_locked_cell = allow_selecting_locked_cell
        if 'allow_selecting_locked_cell' in params:
            self.allow_selecting_locked_cell = params["allow_selecting_locked_cell"]


             
        self.allow_selecting_unlocked_cell = allow_selecting_unlocked_cell
        if 'allow_selecting_unlocked_cell' in params:
            self.allow_selecting_unlocked_cell = params["allow_selecting_unlocked_cell"]


             

    @property
    def allow_deleting_column(self):
        return self.container['allow_deleting_column']

    @allow_deleting_column.setter
    def allow_deleting_column(self, allow_deleting_column):
        self.container['allow_deleting_column'] = allow_deleting_column 
    @property
    def allow_deleting_row(self):
        return self.container['allow_deleting_row']

    @allow_deleting_row.setter
    def allow_deleting_row(self, allow_deleting_row):
        self.container['allow_deleting_row'] = allow_deleting_row 
    @property
    def allow_filtering(self):
        return self.container['allow_filtering']

    @allow_filtering.setter
    def allow_filtering(self, allow_filtering):
        self.container['allow_filtering'] = allow_filtering 
    @property
    def allow_formatting_cell(self):
        return self.container['allow_formatting_cell']

    @allow_formatting_cell.setter
    def allow_formatting_cell(self, allow_formatting_cell):
        self.container['allow_formatting_cell'] = allow_formatting_cell 
    @property
    def allow_formatting_column(self):
        return self.container['allow_formatting_column']

    @allow_formatting_column.setter
    def allow_formatting_column(self, allow_formatting_column):
        self.container['allow_formatting_column'] = allow_formatting_column 
    @property
    def allow_formatting_row(self):
        return self.container['allow_formatting_row']

    @allow_formatting_row.setter
    def allow_formatting_row(self, allow_formatting_row):
        self.container['allow_formatting_row'] = allow_formatting_row 
    @property
    def allow_inserting_column(self):
        return self.container['allow_inserting_column']

    @allow_inserting_column.setter
    def allow_inserting_column(self, allow_inserting_column):
        self.container['allow_inserting_column'] = allow_inserting_column 
    @property
    def allow_inserting_hyperlink(self):
        return self.container['allow_inserting_hyperlink']

    @allow_inserting_hyperlink.setter
    def allow_inserting_hyperlink(self, allow_inserting_hyperlink):
        self.container['allow_inserting_hyperlink'] = allow_inserting_hyperlink 
    @property
    def allow_inserting_row(self):
        return self.container['allow_inserting_row']

    @allow_inserting_row.setter
    def allow_inserting_row(self, allow_inserting_row):
        self.container['allow_inserting_row'] = allow_inserting_row 
    @property
    def allow_sorting(self):
        return self.container['allow_sorting']

    @allow_sorting.setter
    def allow_sorting(self, allow_sorting):
        self.container['allow_sorting'] = allow_sorting 
    @property
    def allow_using_pivot_table(self):
        return self.container['allow_using_pivot_table']

    @allow_using_pivot_table.setter
    def allow_using_pivot_table(self, allow_using_pivot_table):
        self.container['allow_using_pivot_table'] = allow_using_pivot_table 
    @property
    def allow_editing_content(self):
        return self.container['allow_editing_content']

    @allow_editing_content.setter
    def allow_editing_content(self, allow_editing_content):
        self.container['allow_editing_content'] = allow_editing_content 
    @property
    def allow_editing_object(self):
        return self.container['allow_editing_object']

    @allow_editing_object.setter
    def allow_editing_object(self, allow_editing_object):
        self.container['allow_editing_object'] = allow_editing_object 
    @property
    def allow_editing_scenario(self):
        return self.container['allow_editing_scenario']

    @allow_editing_scenario.setter
    def allow_editing_scenario(self, allow_editing_scenario):
        self.container['allow_editing_scenario'] = allow_editing_scenario 
    @property
    def password(self):
        return self.container['password']

    @password.setter
    def password(self, password):
        self.container['password'] = password 
    @property
    def allow_selecting_locked_cell(self):
        return self.container['allow_selecting_locked_cell']

    @allow_selecting_locked_cell.setter
    def allow_selecting_locked_cell(self, allow_selecting_locked_cell):
        self.container['allow_selecting_locked_cell'] = allow_selecting_locked_cell 
    @property
    def allow_selecting_unlocked_cell(self):
        return self.container['allow_selecting_unlocked_cell']

    @allow_selecting_unlocked_cell.setter
    def allow_selecting_unlocked_cell(self, allow_selecting_unlocked_cell):
        self.container['allow_selecting_unlocked_cell'] = allow_selecting_unlocked_cell 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Protection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    