# coding: utf-8
"""
<copyright company="Aspose" file="ProtectWorkbookRequestpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ProtectWorkbookRequest(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'aways_open_read_only' : 'bool',
        'encrypt_with_password' : 'str',
        'protect_current_sheet' : 'Protection',
        'protect_all_sheets' : 'Protection',
        'protect_workbook_structure' : 'str',
        'digital_signature' : 'DigitalSignature',
        'mark_as_final' : 'bool'
    }

    attribute_map = {
        'aways_open_read_only' : 'AwaysOpenReadOnly' ,
        'encrypt_with_password' : 'EncryptWithPassword' ,
        'protect_current_sheet' : 'ProtectCurrentSheet' ,
        'protect_all_sheets' : 'ProtectAllSheets' ,
        'protect_workbook_structure' : 'ProtectWorkbookStructure' ,
        'digital_signature' : 'DigitalSignature' ,
        'mark_as_final' : 'MarkAsFinal' 
    }

    @staticmethod
    def get_swagger_types():
        return ProtectWorkbookRequest.swagger_types

    @staticmethod
    def get_attribute_map():
        return ProtectWorkbookRequest.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,aways_open_read_only=None ,encrypt_with_password=None ,protect_current_sheet=None ,protect_all_sheets=None ,protect_workbook_structure=None ,digital_signature=None ,mark_as_final=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ProtectWorkbookRequest - a model defined in Swagger
        """
        self.container['aways_open_read_only'] = None 
        self.container['encrypt_with_password'] = None 
        self.container['protect_current_sheet'] = None 
        self.container['protect_all_sheets'] = None 
        self.container['protect_workbook_structure'] = None 
        self.container['digital_signature'] = None 
        self.container['mark_as_final'] = None 
        params = locals()
        self.aways_open_read_only = aways_open_read_only
        if 'aways_open_read_only' in params:
            self.aways_open_read_only = params["aways_open_read_only"]


             
        self.encrypt_with_password = encrypt_with_password
        if 'encrypt_with_password' in params:
            self.encrypt_with_password = params["encrypt_with_password"]


             
        self.protect_current_sheet = protect_current_sheet
        if 'protect_current_sheet' in params:
            self.protect_current_sheet = params["protect_current_sheet"]


             
        self.protect_all_sheets = protect_all_sheets
        if 'protect_all_sheets' in params:
            self.protect_all_sheets = params["protect_all_sheets"]


             
        self.protect_workbook_structure = protect_workbook_structure
        if 'protect_workbook_structure' in params:
            self.protect_workbook_structure = params["protect_workbook_structure"]


             
        self.digital_signature = digital_signature
        if 'digital_signature' in params:
            self.digital_signature = params["digital_signature"]


             
        self.mark_as_final = mark_as_final
        if 'mark_as_final' in params:
            self.mark_as_final = params["mark_as_final"]


             

    @property
    def aways_open_read_only(self):
        return self.container['aways_open_read_only']

    @aways_open_read_only.setter
    def aways_open_read_only(self, aways_open_read_only):
        self.container['aways_open_read_only'] = aways_open_read_only 
    @property
    def encrypt_with_password(self):
        return self.container['encrypt_with_password']

    @encrypt_with_password.setter
    def encrypt_with_password(self, encrypt_with_password):
        self.container['encrypt_with_password'] = encrypt_with_password 
    @property
    def protect_current_sheet(self):
        return self.container['protect_current_sheet']

    @protect_current_sheet.setter
    def protect_current_sheet(self, protect_current_sheet):
        self.container['protect_current_sheet'] = protect_current_sheet 
    @property
    def protect_all_sheets(self):
        return self.container['protect_all_sheets']

    @protect_all_sheets.setter
    def protect_all_sheets(self, protect_all_sheets):
        self.container['protect_all_sheets'] = protect_all_sheets 
    @property
    def protect_workbook_structure(self):
        return self.container['protect_workbook_structure']

    @protect_workbook_structure.setter
    def protect_workbook_structure(self, protect_workbook_structure):
        self.container['protect_workbook_structure'] = protect_workbook_structure 
    @property
    def digital_signature(self):
        return self.container['digital_signature']

    @digital_signature.setter
    def digital_signature(self, digital_signature):
        self.container['digital_signature'] = digital_signature 
    @property
    def mark_as_final(self):
        return self.container['mark_as_final']

    @mark_as_final.setter
    def mark_as_final(self, mark_as_final):
        self.container['mark_as_final'] = mark_as_final 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProtectWorkbookRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    