# coding: utf-8
"""
<copyright company="Aspose" file="PivotTablepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PivotTable(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'alt_text_description' : 'str',
        'alt_text_title' : 'str',
        'auto_format_type' : 'str',
        'base_fields' : 'list[PivotField]',
        'column_fields' : 'list[PivotField]',
        'column_grand' : 'bool',
        'column_header_caption' : 'str',
        'column_range' : 'CellArea',
        'custom_list_sort' : 'bool',
        'data_body_range' : 'CellArea',
        'data_field' : 'PivotField',
        'data_fields' : 'list[PivotField]',
        'data_source' : 'list[str]',
        'display_error_string' : 'bool',
        'display_immediate_items' : 'bool',
        'display_null_string' : 'bool',
        'enable_data_value_editing' : 'bool',
        'enable_drilldown' : 'bool',
        'enable_field_dialog' : 'bool',
        'enable_field_list' : 'bool',
        'enable_wizard' : 'bool',
        'error_string' : 'str',
        'field_list_sort_ascending' : 'bool',
        'grand_total_name' : 'str',
        'has_blank_rows' : 'bool',
        'indent' : 'int',
        'is_auto_format' : 'bool',
        'is_grid_drop_zones' : 'bool',
        'is_multiple_field_filters' : 'bool',
        'is_selected' : 'bool',
        'item_print_titles' : 'bool',
        'manual_update' : 'bool',
        'merge_labels' : 'bool',
        'missing_items_limit' : 'str',
        'name' : 'str',
        'null_string' : 'str',
        'page_field_order' : 'str',
        'page_fields' : 'list[PivotField]',
        'page_field_wrap_count' : 'int',
        'pivot_filters' : 'list[PivotFilter]',
        'pivot_table_style_name' : 'str',
        'pivot_table_style_type' : 'str',
        'preserve_formatting' : 'bool',
        'print_drill' : 'bool',
        'print_titles' : 'bool',
        'refresh_data_flag' : 'bool',
        'refresh_data_on_opening_file' : 'bool',
        'row_fields' : 'list[PivotField]',
        'row_grand' : 'bool',
        'row_header_caption' : 'str',
        'row_range' : 'CellArea',
        'save_data' : 'bool',
        'show_data_tips' : 'bool',
        'show_drill' : 'bool',
        'show_empty_col' : 'bool',
        'show_empty_row' : 'bool',
        'show_member_property_tips' : 'bool',
        'show_pivot_style_column_header' : 'bool',
        'show_pivot_style_column_stripes' : 'bool',
        'show_pivot_style_last_column' : 'bool',
        'show_pivot_style_row_header' : 'bool',
        'show_pivot_style_row_stripes' : 'bool',
        'show_row_header_caption' : 'bool',
        'show_values_row' : 'bool',
        'subtotal_hidden_page_items' : 'bool',
        'table_range1' : 'CellArea',
        'table_range2' : 'CellArea',
        'tag' : 'str',
        'link' : 'Link'
    }

    attribute_map = {
        'alt_text_description' : 'AltTextDescription' ,
        'alt_text_title' : 'AltTextTitle' ,
        'auto_format_type' : 'AutoFormatType' ,
        'base_fields' : 'BaseFields' ,
        'column_fields' : 'ColumnFields' ,
        'column_grand' : 'ColumnGrand' ,
        'column_header_caption' : 'ColumnHeaderCaption' ,
        'column_range' : 'ColumnRange' ,
        'custom_list_sort' : 'CustomListSort' ,
        'data_body_range' : 'DataBodyRange' ,
        'data_field' : 'DataField' ,
        'data_fields' : 'DataFields' ,
        'data_source' : 'DataSource' ,
        'display_error_string' : 'DisplayErrorString' ,
        'display_immediate_items' : 'DisplayImmediateItems' ,
        'display_null_string' : 'DisplayNullString' ,
        'enable_data_value_editing' : 'EnableDataValueEditing' ,
        'enable_drilldown' : 'EnableDrilldown' ,
        'enable_field_dialog' : 'EnableFieldDialog' ,
        'enable_field_list' : 'EnableFieldList' ,
        'enable_wizard' : 'EnableWizard' ,
        'error_string' : 'ErrorString' ,
        'field_list_sort_ascending' : 'FieldListSortAscending' ,
        'grand_total_name' : 'GrandTotalName' ,
        'has_blank_rows' : 'HasBlankRows' ,
        'indent' : 'Indent' ,
        'is_auto_format' : 'IsAutoFormat' ,
        'is_grid_drop_zones' : 'IsGridDropZones' ,
        'is_multiple_field_filters' : 'IsMultipleFieldFilters' ,
        'is_selected' : 'IsSelected' ,
        'item_print_titles' : 'ItemPrintTitles' ,
        'manual_update' : 'ManualUpdate' ,
        'merge_labels' : 'MergeLabels' ,
        'missing_items_limit' : 'MissingItemsLimit' ,
        'name' : 'Name' ,
        'null_string' : 'NullString' ,
        'page_field_order' : 'PageFieldOrder' ,
        'page_fields' : 'PageFields' ,
        'page_field_wrap_count' : 'PageFieldWrapCount' ,
        'pivot_filters' : 'PivotFilters' ,
        'pivot_table_style_name' : 'PivotTableStyleName' ,
        'pivot_table_style_type' : 'PivotTableStyleType' ,
        'preserve_formatting' : 'PreserveFormatting' ,
        'print_drill' : 'PrintDrill' ,
        'print_titles' : 'PrintTitles' ,
        'refresh_data_flag' : 'RefreshDataFlag' ,
        'refresh_data_on_opening_file' : 'RefreshDataOnOpeningFile' ,
        'row_fields' : 'RowFields' ,
        'row_grand' : 'RowGrand' ,
        'row_header_caption' : 'RowHeaderCaption' ,
        'row_range' : 'RowRange' ,
        'save_data' : 'SaveData' ,
        'show_data_tips' : 'ShowDataTips' ,
        'show_drill' : 'ShowDrill' ,
        'show_empty_col' : 'ShowEmptyCol' ,
        'show_empty_row' : 'ShowEmptyRow' ,
        'show_member_property_tips' : 'ShowMemberPropertyTips' ,
        'show_pivot_style_column_header' : 'ShowPivotStyleColumnHeader' ,
        'show_pivot_style_column_stripes' : 'ShowPivotStyleColumnStripes' ,
        'show_pivot_style_last_column' : 'ShowPivotStyleLastColumn' ,
        'show_pivot_style_row_header' : 'ShowPivotStyleRowHeader' ,
        'show_pivot_style_row_stripes' : 'ShowPivotStyleRowStripes' ,
        'show_row_header_caption' : 'ShowRowHeaderCaption' ,
        'show_values_row' : 'ShowValuesRow' ,
        'subtotal_hidden_page_items' : 'SubtotalHiddenPageItems' ,
        'table_range1' : 'TableRange1' ,
        'table_range2' : 'TableRange2' ,
        'tag' : 'Tag' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return PivotTable.swagger_types

    @staticmethod
    def get_attribute_map():
        return PivotTable.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,alt_text_description=None ,alt_text_title=None ,auto_format_type=None ,base_fields=None ,column_fields=None ,column_grand=None ,column_header_caption=None ,column_range=None ,custom_list_sort=None ,data_body_range=None ,data_field=None ,data_fields=None ,data_source=None ,display_error_string=None ,display_immediate_items=None ,display_null_string=None ,enable_data_value_editing=None ,enable_drilldown=None ,enable_field_dialog=None ,enable_field_list=None ,enable_wizard=None ,error_string=None ,field_list_sort_ascending=None ,grand_total_name=None ,has_blank_rows=None ,indent=None ,is_auto_format=None ,is_grid_drop_zones=None ,is_multiple_field_filters=None ,is_selected=None ,item_print_titles=None ,manual_update=None ,merge_labels=None ,missing_items_limit=None ,name=None ,null_string=None ,page_field_order=None ,page_fields=None ,page_field_wrap_count=None ,pivot_filters=None ,pivot_table_style_name=None ,pivot_table_style_type=None ,preserve_formatting=None ,print_drill=None ,print_titles=None ,refresh_data_flag=None ,refresh_data_on_opening_file=None ,row_fields=None ,row_grand=None ,row_header_caption=None ,row_range=None ,save_data=None ,show_data_tips=None ,show_drill=None ,show_empty_col=None ,show_empty_row=None ,show_member_property_tips=None ,show_pivot_style_column_header=None ,show_pivot_style_column_stripes=None ,show_pivot_style_last_column=None ,show_pivot_style_row_header=None ,show_pivot_style_row_stripes=None ,show_row_header_caption=None ,show_values_row=None ,subtotal_hidden_page_items=None ,table_range1=None ,table_range2=None ,tag=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PivotTable - a model defined in Swagger
        """
        self.container['alt_text_description'] = None 
        self.container['alt_text_title'] = None 
        self.container['auto_format_type'] = None 
        self.container['base_fields'] = None 
        self.container['column_fields'] = None 
        self.container['column_grand'] = None 
        self.container['column_header_caption'] = None 
        self.container['column_range'] = None 
        self.container['custom_list_sort'] = None 
        self.container['data_body_range'] = None 
        self.container['data_field'] = None 
        self.container['data_fields'] = None 
        self.container['data_source'] = None 
        self.container['display_error_string'] = None 
        self.container['display_immediate_items'] = None 
        self.container['display_null_string'] = None 
        self.container['enable_data_value_editing'] = None 
        self.container['enable_drilldown'] = None 
        self.container['enable_field_dialog'] = None 
        self.container['enable_field_list'] = None 
        self.container['enable_wizard'] = None 
        self.container['error_string'] = None 
        self.container['field_list_sort_ascending'] = None 
        self.container['grand_total_name'] = None 
        self.container['has_blank_rows'] = None 
        self.container['indent'] = None 
        self.container['is_auto_format'] = None 
        self.container['is_grid_drop_zones'] = None 
        self.container['is_multiple_field_filters'] = None 
        self.container['is_selected'] = None 
        self.container['item_print_titles'] = None 
        self.container['manual_update'] = None 
        self.container['merge_labels'] = None 
        self.container['missing_items_limit'] = None 
        self.container['name'] = None 
        self.container['null_string'] = None 
        self.container['page_field_order'] = None 
        self.container['page_fields'] = None 
        self.container['page_field_wrap_count'] = None 
        self.container['pivot_filters'] = None 
        self.container['pivot_table_style_name'] = None 
        self.container['pivot_table_style_type'] = None 
        self.container['preserve_formatting'] = None 
        self.container['print_drill'] = None 
        self.container['print_titles'] = None 
        self.container['refresh_data_flag'] = None 
        self.container['refresh_data_on_opening_file'] = None 
        self.container['row_fields'] = None 
        self.container['row_grand'] = None 
        self.container['row_header_caption'] = None 
        self.container['row_range'] = None 
        self.container['save_data'] = None 
        self.container['show_data_tips'] = None 
        self.container['show_drill'] = None 
        self.container['show_empty_col'] = None 
        self.container['show_empty_row'] = None 
        self.container['show_member_property_tips'] = None 
        self.container['show_pivot_style_column_header'] = None 
        self.container['show_pivot_style_column_stripes'] = None 
        self.container['show_pivot_style_last_column'] = None 
        self.container['show_pivot_style_row_header'] = None 
        self.container['show_pivot_style_row_stripes'] = None 
        self.container['show_row_header_caption'] = None 
        self.container['show_values_row'] = None 
        self.container['subtotal_hidden_page_items'] = None 
        self.container['table_range1'] = None 
        self.container['table_range2'] = None 
        self.container['tag'] = None 
        self.container['link'] = None 
        params = locals()
        self.alt_text_description = alt_text_description
        if 'alt_text_description' in params:
            self.alt_text_description = params["alt_text_description"]


             
        self.alt_text_title = alt_text_title
        if 'alt_text_title' in params:
            self.alt_text_title = params["alt_text_title"]


             
        self.auto_format_type = auto_format_type
        if 'auto_format_type' in params:
            self.auto_format_type = params["auto_format_type"]


             
        self.base_fields = base_fields
        if 'base_fields' in params:
            self.base_fields = params["base_fields"]


             
        self.column_fields = column_fields
        if 'column_fields' in params:
            self.column_fields = params["column_fields"]


             
        self.column_grand = column_grand
        if 'column_grand' in params:
            self.column_grand = params["column_grand"]


             
        self.column_header_caption = column_header_caption
        if 'column_header_caption' in params:
            self.column_header_caption = params["column_header_caption"]


             
        self.column_range = column_range
        if 'column_range' in params:
            self.column_range = params["column_range"]


             
        self.custom_list_sort = custom_list_sort
        if 'custom_list_sort' in params:
            self.custom_list_sort = params["custom_list_sort"]


             
        self.data_body_range = data_body_range
        if 'data_body_range' in params:
            self.data_body_range = params["data_body_range"]


             
        self.data_field = data_field
        if 'data_field' in params:
            self.data_field = params["data_field"]


             
        self.data_fields = data_fields
        if 'data_fields' in params:
            self.data_fields = params["data_fields"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.display_error_string = display_error_string
        if 'display_error_string' in params:
            self.display_error_string = params["display_error_string"]


             
        self.display_immediate_items = display_immediate_items
        if 'display_immediate_items' in params:
            self.display_immediate_items = params["display_immediate_items"]


             
        self.display_null_string = display_null_string
        if 'display_null_string' in params:
            self.display_null_string = params["display_null_string"]


             
        self.enable_data_value_editing = enable_data_value_editing
        if 'enable_data_value_editing' in params:
            self.enable_data_value_editing = params["enable_data_value_editing"]


             
        self.enable_drilldown = enable_drilldown
        if 'enable_drilldown' in params:
            self.enable_drilldown = params["enable_drilldown"]


             
        self.enable_field_dialog = enable_field_dialog
        if 'enable_field_dialog' in params:
            self.enable_field_dialog = params["enable_field_dialog"]


             
        self.enable_field_list = enable_field_list
        if 'enable_field_list' in params:
            self.enable_field_list = params["enable_field_list"]


             
        self.enable_wizard = enable_wizard
        if 'enable_wizard' in params:
            self.enable_wizard = params["enable_wizard"]


             
        self.error_string = error_string
        if 'error_string' in params:
            self.error_string = params["error_string"]


             
        self.field_list_sort_ascending = field_list_sort_ascending
        if 'field_list_sort_ascending' in params:
            self.field_list_sort_ascending = params["field_list_sort_ascending"]


             
        self.grand_total_name = grand_total_name
        if 'grand_total_name' in params:
            self.grand_total_name = params["grand_total_name"]


             
        self.has_blank_rows = has_blank_rows
        if 'has_blank_rows' in params:
            self.has_blank_rows = params["has_blank_rows"]


             
        self.indent = indent
        if 'indent' in params:
            self.indent = params["indent"]


             
        self.is_auto_format = is_auto_format
        if 'is_auto_format' in params:
            self.is_auto_format = params["is_auto_format"]


             
        self.is_grid_drop_zones = is_grid_drop_zones
        if 'is_grid_drop_zones' in params:
            self.is_grid_drop_zones = params["is_grid_drop_zones"]


             
        self.is_multiple_field_filters = is_multiple_field_filters
        if 'is_multiple_field_filters' in params:
            self.is_multiple_field_filters = params["is_multiple_field_filters"]


             
        self.is_selected = is_selected
        if 'is_selected' in params:
            self.is_selected = params["is_selected"]


             
        self.item_print_titles = item_print_titles
        if 'item_print_titles' in params:
            self.item_print_titles = params["item_print_titles"]


             
        self.manual_update = manual_update
        if 'manual_update' in params:
            self.manual_update = params["manual_update"]


             
        self.merge_labels = merge_labels
        if 'merge_labels' in params:
            self.merge_labels = params["merge_labels"]


             
        self.missing_items_limit = missing_items_limit
        if 'missing_items_limit' in params:
            self.missing_items_limit = params["missing_items_limit"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.null_string = null_string
        if 'null_string' in params:
            self.null_string = params["null_string"]


             
        self.page_field_order = page_field_order
        if 'page_field_order' in params:
            self.page_field_order = params["page_field_order"]


             
        self.page_fields = page_fields
        if 'page_fields' in params:
            self.page_fields = params["page_fields"]


             
        self.page_field_wrap_count = page_field_wrap_count
        if 'page_field_wrap_count' in params:
            self.page_field_wrap_count = params["page_field_wrap_count"]


             
        self.pivot_filters = pivot_filters
        if 'pivot_filters' in params:
            self.pivot_filters = params["pivot_filters"]


             
        self.pivot_table_style_name = pivot_table_style_name
        if 'pivot_table_style_name' in params:
            self.pivot_table_style_name = params["pivot_table_style_name"]


             
        self.pivot_table_style_type = pivot_table_style_type
        if 'pivot_table_style_type' in params:
            self.pivot_table_style_type = params["pivot_table_style_type"]


             
        self.preserve_formatting = preserve_formatting
        if 'preserve_formatting' in params:
            self.preserve_formatting = params["preserve_formatting"]


             
        self.print_drill = print_drill
        if 'print_drill' in params:
            self.print_drill = params["print_drill"]


             
        self.print_titles = print_titles
        if 'print_titles' in params:
            self.print_titles = params["print_titles"]


             
        self.refresh_data_flag = refresh_data_flag
        if 'refresh_data_flag' in params:
            self.refresh_data_flag = params["refresh_data_flag"]


             
        self.refresh_data_on_opening_file = refresh_data_on_opening_file
        if 'refresh_data_on_opening_file' in params:
            self.refresh_data_on_opening_file = params["refresh_data_on_opening_file"]


             
        self.row_fields = row_fields
        if 'row_fields' in params:
            self.row_fields = params["row_fields"]


             
        self.row_grand = row_grand
        if 'row_grand' in params:
            self.row_grand = params["row_grand"]


             
        self.row_header_caption = row_header_caption
        if 'row_header_caption' in params:
            self.row_header_caption = params["row_header_caption"]


             
        self.row_range = row_range
        if 'row_range' in params:
            self.row_range = params["row_range"]


             
        self.save_data = save_data
        if 'save_data' in params:
            self.save_data = params["save_data"]


             
        self.show_data_tips = show_data_tips
        if 'show_data_tips' in params:
            self.show_data_tips = params["show_data_tips"]


             
        self.show_drill = show_drill
        if 'show_drill' in params:
            self.show_drill = params["show_drill"]


             
        self.show_empty_col = show_empty_col
        if 'show_empty_col' in params:
            self.show_empty_col = params["show_empty_col"]


             
        self.show_empty_row = show_empty_row
        if 'show_empty_row' in params:
            self.show_empty_row = params["show_empty_row"]


             
        self.show_member_property_tips = show_member_property_tips
        if 'show_member_property_tips' in params:
            self.show_member_property_tips = params["show_member_property_tips"]


             
        self.show_pivot_style_column_header = show_pivot_style_column_header
        if 'show_pivot_style_column_header' in params:
            self.show_pivot_style_column_header = params["show_pivot_style_column_header"]


             
        self.show_pivot_style_column_stripes = show_pivot_style_column_stripes
        if 'show_pivot_style_column_stripes' in params:
            self.show_pivot_style_column_stripes = params["show_pivot_style_column_stripes"]


             
        self.show_pivot_style_last_column = show_pivot_style_last_column
        if 'show_pivot_style_last_column' in params:
            self.show_pivot_style_last_column = params["show_pivot_style_last_column"]


             
        self.show_pivot_style_row_header = show_pivot_style_row_header
        if 'show_pivot_style_row_header' in params:
            self.show_pivot_style_row_header = params["show_pivot_style_row_header"]


             
        self.show_pivot_style_row_stripes = show_pivot_style_row_stripes
        if 'show_pivot_style_row_stripes' in params:
            self.show_pivot_style_row_stripes = params["show_pivot_style_row_stripes"]


             
        self.show_row_header_caption = show_row_header_caption
        if 'show_row_header_caption' in params:
            self.show_row_header_caption = params["show_row_header_caption"]


             
        self.show_values_row = show_values_row
        if 'show_values_row' in params:
            self.show_values_row = params["show_values_row"]


             
        self.subtotal_hidden_page_items = subtotal_hidden_page_items
        if 'subtotal_hidden_page_items' in params:
            self.subtotal_hidden_page_items = params["subtotal_hidden_page_items"]


             
        self.table_range1 = table_range1
        if 'table_range1' in params:
            self.table_range1 = params["table_range1"]


             
        self.table_range2 = table_range2
        if 'table_range2' in params:
            self.table_range2 = params["table_range2"]


             
        self.tag = tag
        if 'tag' in params:
            self.tag = params["tag"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def alt_text_description(self):
        return self.container['alt_text_description']

    @alt_text_description.setter
    def alt_text_description(self, alt_text_description):
        self.container['alt_text_description'] = alt_text_description 
    @property
    def alt_text_title(self):
        return self.container['alt_text_title']

    @alt_text_title.setter
    def alt_text_title(self, alt_text_title):
        self.container['alt_text_title'] = alt_text_title 
    @property
    def auto_format_type(self):
        return self.container['auto_format_type']

    @auto_format_type.setter
    def auto_format_type(self, auto_format_type):
        self.container['auto_format_type'] = auto_format_type 
    @property
    def base_fields(self):
        return self.container['base_fields']

    @base_fields.setter
    def base_fields(self, base_fields):
        self.container['base_fields'] = base_fields 
    @property
    def column_fields(self):
        return self.container['column_fields']

    @column_fields.setter
    def column_fields(self, column_fields):
        self.container['column_fields'] = column_fields 
    @property
    def column_grand(self):
        return self.container['column_grand']

    @column_grand.setter
    def column_grand(self, column_grand):
        self.container['column_grand'] = column_grand 
    @property
    def column_header_caption(self):
        return self.container['column_header_caption']

    @column_header_caption.setter
    def column_header_caption(self, column_header_caption):
        self.container['column_header_caption'] = column_header_caption 
    @property
    def column_range(self):
        return self.container['column_range']

    @column_range.setter
    def column_range(self, column_range):
        self.container['column_range'] = column_range 
    @property
    def custom_list_sort(self):
        return self.container['custom_list_sort']

    @custom_list_sort.setter
    def custom_list_sort(self, custom_list_sort):
        self.container['custom_list_sort'] = custom_list_sort 
    @property
    def data_body_range(self):
        return self.container['data_body_range']

    @data_body_range.setter
    def data_body_range(self, data_body_range):
        self.container['data_body_range'] = data_body_range 
    @property
    def data_field(self):
        return self.container['data_field']

    @data_field.setter
    def data_field(self, data_field):
        self.container['data_field'] = data_field 
    @property
    def data_fields(self):
        return self.container['data_fields']

    @data_fields.setter
    def data_fields(self, data_fields):
        self.container['data_fields'] = data_fields 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def display_error_string(self):
        return self.container['display_error_string']

    @display_error_string.setter
    def display_error_string(self, display_error_string):
        self.container['display_error_string'] = display_error_string 
    @property
    def display_immediate_items(self):
        return self.container['display_immediate_items']

    @display_immediate_items.setter
    def display_immediate_items(self, display_immediate_items):
        self.container['display_immediate_items'] = display_immediate_items 
    @property
    def display_null_string(self):
        return self.container['display_null_string']

    @display_null_string.setter
    def display_null_string(self, display_null_string):
        self.container['display_null_string'] = display_null_string 
    @property
    def enable_data_value_editing(self):
        return self.container['enable_data_value_editing']

    @enable_data_value_editing.setter
    def enable_data_value_editing(self, enable_data_value_editing):
        self.container['enable_data_value_editing'] = enable_data_value_editing 
    @property
    def enable_drilldown(self):
        return self.container['enable_drilldown']

    @enable_drilldown.setter
    def enable_drilldown(self, enable_drilldown):
        self.container['enable_drilldown'] = enable_drilldown 
    @property
    def enable_field_dialog(self):
        return self.container['enable_field_dialog']

    @enable_field_dialog.setter
    def enable_field_dialog(self, enable_field_dialog):
        self.container['enable_field_dialog'] = enable_field_dialog 
    @property
    def enable_field_list(self):
        return self.container['enable_field_list']

    @enable_field_list.setter
    def enable_field_list(self, enable_field_list):
        self.container['enable_field_list'] = enable_field_list 
    @property
    def enable_wizard(self):
        return self.container['enable_wizard']

    @enable_wizard.setter
    def enable_wizard(self, enable_wizard):
        self.container['enable_wizard'] = enable_wizard 
    @property
    def error_string(self):
        return self.container['error_string']

    @error_string.setter
    def error_string(self, error_string):
        self.container['error_string'] = error_string 
    @property
    def field_list_sort_ascending(self):
        return self.container['field_list_sort_ascending']

    @field_list_sort_ascending.setter
    def field_list_sort_ascending(self, field_list_sort_ascending):
        self.container['field_list_sort_ascending'] = field_list_sort_ascending 
    @property
    def grand_total_name(self):
        return self.container['grand_total_name']

    @grand_total_name.setter
    def grand_total_name(self, grand_total_name):
        self.container['grand_total_name'] = grand_total_name 
    @property
    def has_blank_rows(self):
        return self.container['has_blank_rows']

    @has_blank_rows.setter
    def has_blank_rows(self, has_blank_rows):
        self.container['has_blank_rows'] = has_blank_rows 
    @property
    def indent(self):
        return self.container['indent']

    @indent.setter
    def indent(self, indent):
        self.container['indent'] = indent 
    @property
    def is_auto_format(self):
        return self.container['is_auto_format']

    @is_auto_format.setter
    def is_auto_format(self, is_auto_format):
        self.container['is_auto_format'] = is_auto_format 
    @property
    def is_grid_drop_zones(self):
        return self.container['is_grid_drop_zones']

    @is_grid_drop_zones.setter
    def is_grid_drop_zones(self, is_grid_drop_zones):
        self.container['is_grid_drop_zones'] = is_grid_drop_zones 
    @property
    def is_multiple_field_filters(self):
        return self.container['is_multiple_field_filters']

    @is_multiple_field_filters.setter
    def is_multiple_field_filters(self, is_multiple_field_filters):
        self.container['is_multiple_field_filters'] = is_multiple_field_filters 
    @property
    def is_selected(self):
        return self.container['is_selected']

    @is_selected.setter
    def is_selected(self, is_selected):
        self.container['is_selected'] = is_selected 
    @property
    def item_print_titles(self):
        return self.container['item_print_titles']

    @item_print_titles.setter
    def item_print_titles(self, item_print_titles):
        self.container['item_print_titles'] = item_print_titles 
    @property
    def manual_update(self):
        return self.container['manual_update']

    @manual_update.setter
    def manual_update(self, manual_update):
        self.container['manual_update'] = manual_update 
    @property
    def merge_labels(self):
        return self.container['merge_labels']

    @merge_labels.setter
    def merge_labels(self, merge_labels):
        self.container['merge_labels'] = merge_labels 
    @property
    def missing_items_limit(self):
        return self.container['missing_items_limit']

    @missing_items_limit.setter
    def missing_items_limit(self, missing_items_limit):
        self.container['missing_items_limit'] = missing_items_limit 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def null_string(self):
        return self.container['null_string']

    @null_string.setter
    def null_string(self, null_string):
        self.container['null_string'] = null_string 
    @property
    def page_field_order(self):
        return self.container['page_field_order']

    @page_field_order.setter
    def page_field_order(self, page_field_order):
        self.container['page_field_order'] = page_field_order 
    @property
    def page_fields(self):
        return self.container['page_fields']

    @page_fields.setter
    def page_fields(self, page_fields):
        self.container['page_fields'] = page_fields 
    @property
    def page_field_wrap_count(self):
        return self.container['page_field_wrap_count']

    @page_field_wrap_count.setter
    def page_field_wrap_count(self, page_field_wrap_count):
        self.container['page_field_wrap_count'] = page_field_wrap_count 
    @property
    def pivot_filters(self):
        return self.container['pivot_filters']

    @pivot_filters.setter
    def pivot_filters(self, pivot_filters):
        self.container['pivot_filters'] = pivot_filters 
    @property
    def pivot_table_style_name(self):
        return self.container['pivot_table_style_name']

    @pivot_table_style_name.setter
    def pivot_table_style_name(self, pivot_table_style_name):
        self.container['pivot_table_style_name'] = pivot_table_style_name 
    @property
    def pivot_table_style_type(self):
        return self.container['pivot_table_style_type']

    @pivot_table_style_type.setter
    def pivot_table_style_type(self, pivot_table_style_type):
        self.container['pivot_table_style_type'] = pivot_table_style_type 
    @property
    def preserve_formatting(self):
        return self.container['preserve_formatting']

    @preserve_formatting.setter
    def preserve_formatting(self, preserve_formatting):
        self.container['preserve_formatting'] = preserve_formatting 
    @property
    def print_drill(self):
        return self.container['print_drill']

    @print_drill.setter
    def print_drill(self, print_drill):
        self.container['print_drill'] = print_drill 
    @property
    def print_titles(self):
        return self.container['print_titles']

    @print_titles.setter
    def print_titles(self, print_titles):
        self.container['print_titles'] = print_titles 
    @property
    def refresh_data_flag(self):
        return self.container['refresh_data_flag']

    @refresh_data_flag.setter
    def refresh_data_flag(self, refresh_data_flag):
        self.container['refresh_data_flag'] = refresh_data_flag 
    @property
    def refresh_data_on_opening_file(self):
        return self.container['refresh_data_on_opening_file']

    @refresh_data_on_opening_file.setter
    def refresh_data_on_opening_file(self, refresh_data_on_opening_file):
        self.container['refresh_data_on_opening_file'] = refresh_data_on_opening_file 
    @property
    def row_fields(self):
        return self.container['row_fields']

    @row_fields.setter
    def row_fields(self, row_fields):
        self.container['row_fields'] = row_fields 
    @property
    def row_grand(self):
        return self.container['row_grand']

    @row_grand.setter
    def row_grand(self, row_grand):
        self.container['row_grand'] = row_grand 
    @property
    def row_header_caption(self):
        return self.container['row_header_caption']

    @row_header_caption.setter
    def row_header_caption(self, row_header_caption):
        self.container['row_header_caption'] = row_header_caption 
    @property
    def row_range(self):
        return self.container['row_range']

    @row_range.setter
    def row_range(self, row_range):
        self.container['row_range'] = row_range 
    @property
    def save_data(self):
        return self.container['save_data']

    @save_data.setter
    def save_data(self, save_data):
        self.container['save_data'] = save_data 
    @property
    def show_data_tips(self):
        return self.container['show_data_tips']

    @show_data_tips.setter
    def show_data_tips(self, show_data_tips):
        self.container['show_data_tips'] = show_data_tips 
    @property
    def show_drill(self):
        return self.container['show_drill']

    @show_drill.setter
    def show_drill(self, show_drill):
        self.container['show_drill'] = show_drill 
    @property
    def show_empty_col(self):
        return self.container['show_empty_col']

    @show_empty_col.setter
    def show_empty_col(self, show_empty_col):
        self.container['show_empty_col'] = show_empty_col 
    @property
    def show_empty_row(self):
        return self.container['show_empty_row']

    @show_empty_row.setter
    def show_empty_row(self, show_empty_row):
        self.container['show_empty_row'] = show_empty_row 
    @property
    def show_member_property_tips(self):
        return self.container['show_member_property_tips']

    @show_member_property_tips.setter
    def show_member_property_tips(self, show_member_property_tips):
        self.container['show_member_property_tips'] = show_member_property_tips 
    @property
    def show_pivot_style_column_header(self):
        return self.container['show_pivot_style_column_header']

    @show_pivot_style_column_header.setter
    def show_pivot_style_column_header(self, show_pivot_style_column_header):
        self.container['show_pivot_style_column_header'] = show_pivot_style_column_header 
    @property
    def show_pivot_style_column_stripes(self):
        return self.container['show_pivot_style_column_stripes']

    @show_pivot_style_column_stripes.setter
    def show_pivot_style_column_stripes(self, show_pivot_style_column_stripes):
        self.container['show_pivot_style_column_stripes'] = show_pivot_style_column_stripes 
    @property
    def show_pivot_style_last_column(self):
        return self.container['show_pivot_style_last_column']

    @show_pivot_style_last_column.setter
    def show_pivot_style_last_column(self, show_pivot_style_last_column):
        self.container['show_pivot_style_last_column'] = show_pivot_style_last_column 
    @property
    def show_pivot_style_row_header(self):
        return self.container['show_pivot_style_row_header']

    @show_pivot_style_row_header.setter
    def show_pivot_style_row_header(self, show_pivot_style_row_header):
        self.container['show_pivot_style_row_header'] = show_pivot_style_row_header 
    @property
    def show_pivot_style_row_stripes(self):
        return self.container['show_pivot_style_row_stripes']

    @show_pivot_style_row_stripes.setter
    def show_pivot_style_row_stripes(self, show_pivot_style_row_stripes):
        self.container['show_pivot_style_row_stripes'] = show_pivot_style_row_stripes 
    @property
    def show_row_header_caption(self):
        return self.container['show_row_header_caption']

    @show_row_header_caption.setter
    def show_row_header_caption(self, show_row_header_caption):
        self.container['show_row_header_caption'] = show_row_header_caption 
    @property
    def show_values_row(self):
        return self.container['show_values_row']

    @show_values_row.setter
    def show_values_row(self, show_values_row):
        self.container['show_values_row'] = show_values_row 
    @property
    def subtotal_hidden_page_items(self):
        return self.container['subtotal_hidden_page_items']

    @subtotal_hidden_page_items.setter
    def subtotal_hidden_page_items(self, subtotal_hidden_page_items):
        self.container['subtotal_hidden_page_items'] = subtotal_hidden_page_items 
    @property
    def table_range1(self):
        return self.container['table_range1']

    @table_range1.setter
    def table_range1(self, table_range1):
        self.container['table_range1'] = table_range1 
    @property
    def table_range2(self):
        return self.container['table_range2']

    @table_range2.setter
    def table_range2(self, table_range2):
        self.container['table_range2'] = table_range2 
    @property
    def tag(self):
        return self.container['tag']

    @tag.setter
    def tag(self, tag):
        self.container['tag'] = tag 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PivotTable):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    