# coding: utf-8
"""
<copyright company="Aspose" file="PicFormatOptionpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PicFormatOption(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'type' : 'str',
        'scale' : 'float',
        'left' : 'float',
        'right' : 'float',
        'top' : 'float',
        'bottom' : 'float'
    }

    attribute_map = {
        'type' : 'Type' ,
        'scale' : 'Scale' ,
        'left' : 'Left' ,
        'right' : 'Right' ,
        'top' : 'Top' ,
        'bottom' : 'Bottom' 
    }

    @staticmethod
    def get_swagger_types():
        return PicFormatOption.swagger_types

    @staticmethod
    def get_attribute_map():
        return PicFormatOption.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,type=None ,scale=None ,left=None ,right=None ,top=None ,bottom=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PicFormatOption - a model defined in Swagger
        """
        self.container['type'] = None 
        self.container['scale'] = None 
        self.container['left'] = None 
        self.container['right'] = None 
        self.container['top'] = None 
        self.container['bottom'] = None 
        params = locals()
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             
        self.scale = scale
        if 'scale' in params:
            self.scale = params["scale"]


             
        self.left = left
        if 'left' in params:
            self.left = params["left"]


             
        self.right = right
        if 'right' in params:
            self.right = params["right"]


             
        self.top = top
        if 'top' in params:
            self.top = params["top"]


             
        self.bottom = bottom
        if 'bottom' in params:
            self.bottom = params["bottom"]


             

    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 
    @property
    def scale(self):
        return self.container['scale']

    @scale.setter
    def scale(self, scale):
        self.container['scale'] = scale 
    @property
    def left(self):
        return self.container['left']

    @left.setter
    def left(self, left):
        self.container['left'] = left 
    @property
    def right(self):
        return self.container['right']

    @right.setter
    def right(self, right):
        self.container['right'] = right 
    @property
    def top(self):
        return self.container['top']

    @top.setter
    def top(self, top):
        self.container['top'] = top 
    @property
    def bottom(self):
        return self.container['bottom']

    @bottom.setter
    def bottom(self, bottom):
        self.container['bottom'] = bottom 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PicFormatOption):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    