# coding: utf-8
"""
<copyright company="Aspose" file="PasteOptionspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class PasteOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'only_visible_cells' : 'bool',
        'paste_type' : 'str',
        'skip_blanks' : 'bool',
        'transpose' : 'bool'
    }

    attribute_map = {
        'only_visible_cells' : 'OnlyVisibleCells' ,
        'paste_type' : 'PasteType' ,
        'skip_blanks' : 'SkipBlanks' ,
        'transpose' : 'Transpose' 
    }

    @staticmethod
    def get_swagger_types():
        return PasteOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return PasteOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,only_visible_cells=None ,paste_type=None ,skip_blanks=None ,transpose=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        PasteOptions - a model defined in Swagger
        """
        self.container['only_visible_cells'] = None 
        self.container['paste_type'] = None 
        self.container['skip_blanks'] = None 
        self.container['transpose'] = None 
        params = locals()
        self.only_visible_cells = only_visible_cells
        if 'only_visible_cells' in params:
            self.only_visible_cells = params["only_visible_cells"]


             
        self.paste_type = paste_type
        if 'paste_type' in params:
            self.paste_type = params["paste_type"]


             
        self.skip_blanks = skip_blanks
        if 'skip_blanks' in params:
            self.skip_blanks = params["skip_blanks"]


             
        self.transpose = transpose
        if 'transpose' in params:
            self.transpose = params["transpose"]


             

    @property
    def only_visible_cells(self):
        return self.container['only_visible_cells']

    @only_visible_cells.setter
    def only_visible_cells(self, only_visible_cells):
        self.container['only_visible_cells'] = only_visible_cells 
    @property
    def paste_type(self):
        return self.container['paste_type']

    @paste_type.setter
    def paste_type(self, paste_type):
        self.container['paste_type'] = paste_type 
    @property
    def skip_blanks(self):
        return self.container['skip_blanks']

    @skip_blanks.setter
    def skip_blanks(self, skip_blanks):
        self.container['skip_blanks'] = skip_blanks 
    @property
    def transpose(self):
        return self.container['transpose']

    @transpose.setter
    def transpose(self, transpose):
        self.container['transpose'] = transpose 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, PasteOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    