# coding: utf-8
"""
<copyright company="Aspose" file="MergeQueriespy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class MergeQueries(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'data_query_name_a' : 'str',
        'data_a_index_field' : 'str',
        'data_query_name_b' : 'str',
        'data_b_index_field' : 'str',
        'join_type' : 'str',
        'applied_operate_type' : 'str'
    }

    attribute_map = {
        'data_query_name_a' : 'DataQueryNameA' ,
        'data_a_index_field' : 'DataAIndexField' ,
        'data_query_name_b' : 'DataQueryNameB' ,
        'data_b_index_field' : 'DataBIndexField' ,
        'join_type' : 'JoinType' ,
        'applied_operate_type' : 'AppliedOperateType' 
    }

    @staticmethod
    def get_swagger_types():
        return MergeQueries.swagger_types

    @staticmethod
    def get_attribute_map():
        return MergeQueries.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,data_query_name_a=None ,data_a_index_field=None ,data_query_name_b=None ,data_b_index_field=None ,join_type=None ,applied_operate_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        MergeQueries - a model defined in Swagger
        """
        self.container['data_query_name_a'] = None 
        self.container['data_a_index_field'] = None 
        self.container['data_query_name_b'] = None 
        self.container['data_b_index_field'] = None 
        self.container['join_type'] = None 
        self.container['applied_operate_type'] = None 
        params = locals()
        self.data_query_name_a = data_query_name_a
        if 'data_query_name_a' in params:
            self.data_query_name_a = params["data_query_name_a"]


             
        self.data_a_index_field = data_a_index_field
        if 'data_a_index_field' in params:
            self.data_a_index_field = params["data_a_index_field"]


             
        self.data_query_name_b = data_query_name_b
        if 'data_query_name_b' in params:
            self.data_query_name_b = params["data_query_name_b"]


             
        self.data_b_index_field = data_b_index_field
        if 'data_b_index_field' in params:
            self.data_b_index_field = params["data_b_index_field"]


             
        self.join_type = join_type
        if 'join_type' in params:
            self.join_type = params["join_type"]


             
        self.applied_operate_type = applied_operate_type
        if 'applied_operate_type' in params:
            self.applied_operate_type = params["applied_operate_type"]


             

    @property
    def data_query_name_a(self):
        return self.container['data_query_name_a']

    @data_query_name_a.setter
    def data_query_name_a(self, data_query_name_a):
        self.container['data_query_name_a'] = data_query_name_a 
    @property
    def data_a_index_field(self):
        return self.container['data_a_index_field']

    @data_a_index_field.setter
    def data_a_index_field(self, data_a_index_field):
        self.container['data_a_index_field'] = data_a_index_field 
    @property
    def data_query_name_b(self):
        return self.container['data_query_name_b']

    @data_query_name_b.setter
    def data_query_name_b(self, data_query_name_b):
        self.container['data_query_name_b'] = data_query_name_b 
    @property
    def data_b_index_field(self):
        return self.container['data_b_index_field']

    @data_b_index_field.setter
    def data_b_index_field(self, data_b_index_field):
        self.container['data_b_index_field'] = data_b_index_field 
    @property
    def join_type(self):
        return self.container['join_type']

    @join_type.setter
    def join_type(self, join_type):
        self.container['join_type'] = join_type 
    @property
    def applied_operate_type(self):
        return self.container['applied_operate_type']

    @applied_operate_type.setter
    def applied_operate_type(self, applied_operate_type):
        self.container['applied_operate_type'] = applied_operate_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, MergeQueries):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    