# coding: utf-8
"""
<copyright company="Aspose" file="MatchConditionRequestpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class MatchConditionRequest(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'regex_pattern' : 'str',
        'full_match_conditions' : 'list[str]'
    }

    attribute_map = {
        'regex_pattern' : 'RegexPattern' ,
        'full_match_conditions' : 'FullMatchConditions' 
    }

    @staticmethod
    def get_swagger_types():
        return MatchConditionRequest.swagger_types

    @staticmethod
    def get_attribute_map():
        return MatchConditionRequest.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,regex_pattern=None ,full_match_conditions=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        MatchConditionRequest - a model defined in Swagger
        """
        self.container['regex_pattern'] = None 
        self.container['full_match_conditions'] = None 
        params = locals()
        self.regex_pattern = regex_pattern
        if 'regex_pattern' in params:
            self.regex_pattern = params["regex_pattern"]


             
        self.full_match_conditions = full_match_conditions
        if 'full_match_conditions' in params:
            self.full_match_conditions = params["full_match_conditions"]


             

    @property
    def regex_pattern(self):
        return self.container['regex_pattern']

    @regex_pattern.setter
    def regex_pattern(self, regex_pattern):
        self.container['regex_pattern'] = regex_pattern 
    @property
    def full_match_conditions(self):
        return self.container['full_match_conditions']

    @full_match_conditions.setter
    def full_match_conditions(self, full_match_conditions):
        self.container['full_match_conditions'] = full_match_conditions 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, MatchConditionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    