# coding: utf-8
"""
<copyright company="Aspose" file="Markerpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Marker(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'border' : 'Line',
        'area' : 'Area',
        'marker_size' : 'int',
        'marker_style' : 'str'
    }

    attribute_map = {
        'border' : 'Border' ,
        'area' : 'Area' ,
        'marker_size' : 'MarkerSize' ,
        'marker_style' : 'MarkerStyle' 
    }

    @staticmethod
    def get_swagger_types():
        return Marker.swagger_types

    @staticmethod
    def get_attribute_map():
        return Marker.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,border=None ,area=None ,marker_size=None ,marker_style=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Marker - a model defined in Swagger
        """
        self.container['border'] = None 
        self.container['area'] = None 
        self.container['marker_size'] = None 
        self.container['marker_style'] = None 
        params = locals()
        self.border = border
        if 'border' in params:
            self.border = params["border"]


             
        self.area = area
        if 'area' in params:
            self.area = params["area"]


             
        self.marker_size = marker_size
        if 'marker_size' in params:
            self.marker_size = params["marker_size"]


             
        self.marker_style = marker_style
        if 'marker_style' in params:
            self.marker_style = params["marker_style"]


             

    @property
    def border(self):
        return self.container['border']

    @border.setter
    def border(self, border):
        self.container['border'] = border 
    @property
    def area(self):
        return self.container['area']

    @area.setter
    def area(self, area):
        self.container['area'] = area 
    @property
    def marker_size(self):
        return self.container['marker_size']

    @marker_size.setter
    def marker_size(self, marker_size):
        self.container['marker_size'] = marker_size 
    @property
    def marker_style(self):
        return self.container['marker_style']

    @marker_style.setter
    def marker_style(self, marker_style):
        self.container['marker_style'] = marker_style 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Marker):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    