# coding: utf-8
"""
<copyright company="Aspose" file="MHtmlSaveOptionspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class MHtmlSaveOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'attached_files_directory' : 'str',
        'attached_files_url_prefix' : 'str',
        'encoding' : 'str',
        'export_active_worksheet_only' : 'bool',
        'export_chart_image_format' : 'str',
        'export_images_as_base64' : 'bool',
        'hidden_col_display_type' : 'str',
        'hidden_row_display_type' : 'str',
        'html_cross_string_type' : 'str',
        'is_exp_image_to_temp_dir' : 'bool',
        'page_title' : 'str',
        'parse_html_tag_in_cell' : 'bool',
        'save_format' : 'str',
        'cached_file_folder' : 'str',
        'clear_data' : 'bool',
        'create_directory' : 'bool',
        'enable_http_compression' : 'bool',
        'refresh_chart_cache' : 'bool',
        'sort_names' : 'bool',
        'validate_merged_areas' : 'bool'
    }

    attribute_map = {
        'attached_files_directory' : 'AttachedFilesDirectory' ,
        'attached_files_url_prefix' : 'AttachedFilesUrlPrefix' ,
        'encoding' : 'Encoding' ,
        'export_active_worksheet_only' : 'ExportActiveWorksheetOnly' ,
        'export_chart_image_format' : 'ExportChartImageFormat' ,
        'export_images_as_base64' : 'ExportImagesAsBase64' ,
        'hidden_col_display_type' : 'HiddenColDisplayType' ,
        'hidden_row_display_type' : 'HiddenRowDisplayType' ,
        'html_cross_string_type' : 'HtmlCrossStringType' ,
        'is_exp_image_to_temp_dir' : 'IsExpImageToTempDir' ,
        'page_title' : 'PageTitle' ,
        'parse_html_tag_in_cell' : 'ParseHtmlTagInCell' ,
        'save_format' : 'SaveFormat' ,
        'cached_file_folder' : 'CachedFileFolder' ,
        'clear_data' : 'ClearData' ,
        'create_directory' : 'CreateDirectory' ,
        'enable_http_compression' : 'EnableHTTPCompression' ,
        'refresh_chart_cache' : 'RefreshChartCache' ,
        'sort_names' : 'SortNames' ,
        'validate_merged_areas' : 'ValidateMergedAreas' 
    }

    @staticmethod
    def get_swagger_types():
        return MHtmlSaveOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return MHtmlSaveOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,attached_files_directory=None ,attached_files_url_prefix=None ,encoding=None ,export_active_worksheet_only=None ,export_chart_image_format=None ,export_images_as_base64=None ,hidden_col_display_type=None ,hidden_row_display_type=None ,html_cross_string_type=None ,is_exp_image_to_temp_dir=None ,page_title=None ,parse_html_tag_in_cell=None ,save_format=None ,cached_file_folder=None ,clear_data=None ,create_directory=None ,enable_http_compression=None ,refresh_chart_cache=None ,sort_names=None ,validate_merged_areas=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        MHtmlSaveOptions - a model defined in Swagger
        """
        self.container['attached_files_directory'] = None 
        self.container['attached_files_url_prefix'] = None 
        self.container['encoding'] = None 
        self.container['export_active_worksheet_only'] = None 
        self.container['export_chart_image_format'] = None 
        self.container['export_images_as_base64'] = None 
        self.container['hidden_col_display_type'] = None 
        self.container['hidden_row_display_type'] = None 
        self.container['html_cross_string_type'] = None 
        self.container['is_exp_image_to_temp_dir'] = None 
        self.container['page_title'] = None 
        self.container['parse_html_tag_in_cell'] = None 
        self.container['save_format'] = None 
        self.container['cached_file_folder'] = None 
        self.container['clear_data'] = None 
        self.container['create_directory'] = None 
        self.container['enable_http_compression'] = None 
        self.container['refresh_chart_cache'] = None 
        self.container['sort_names'] = None 
        self.container['validate_merged_areas'] = None 
        params = locals()
        self.attached_files_directory = attached_files_directory
        if 'attached_files_directory' in params:
            self.attached_files_directory = params["attached_files_directory"]


             
        self.attached_files_url_prefix = attached_files_url_prefix
        if 'attached_files_url_prefix' in params:
            self.attached_files_url_prefix = params["attached_files_url_prefix"]


             
        self.encoding = encoding
        if 'encoding' in params:
            self.encoding = params["encoding"]


             
        self.export_active_worksheet_only = export_active_worksheet_only
        if 'export_active_worksheet_only' in params:
            self.export_active_worksheet_only = params["export_active_worksheet_only"]


             
        self.export_chart_image_format = export_chart_image_format
        if 'export_chart_image_format' in params:
            self.export_chart_image_format = params["export_chart_image_format"]


             
        self.export_images_as_base64 = export_images_as_base64
        if 'export_images_as_base64' in params:
            self.export_images_as_base64 = params["export_images_as_base64"]


             
        self.hidden_col_display_type = hidden_col_display_type
        if 'hidden_col_display_type' in params:
            self.hidden_col_display_type = params["hidden_col_display_type"]


             
        self.hidden_row_display_type = hidden_row_display_type
        if 'hidden_row_display_type' in params:
            self.hidden_row_display_type = params["hidden_row_display_type"]


             
        self.html_cross_string_type = html_cross_string_type
        if 'html_cross_string_type' in params:
            self.html_cross_string_type = params["html_cross_string_type"]


             
        self.is_exp_image_to_temp_dir = is_exp_image_to_temp_dir
        if 'is_exp_image_to_temp_dir' in params:
            self.is_exp_image_to_temp_dir = params["is_exp_image_to_temp_dir"]


             
        self.page_title = page_title
        if 'page_title' in params:
            self.page_title = params["page_title"]


             
        self.parse_html_tag_in_cell = parse_html_tag_in_cell
        if 'parse_html_tag_in_cell' in params:
            self.parse_html_tag_in_cell = params["parse_html_tag_in_cell"]


             
        self.save_format = save_format
        if 'save_format' in params:
            self.save_format = params["save_format"]


             
        self.cached_file_folder = cached_file_folder
        if 'cached_file_folder' in params:
            self.cached_file_folder = params["cached_file_folder"]


             
        self.clear_data = clear_data
        if 'clear_data' in params:
            self.clear_data = params["clear_data"]


             
        self.create_directory = create_directory
        if 'create_directory' in params:
            self.create_directory = params["create_directory"]


             
        self.enable_http_compression = enable_http_compression
        if 'enable_http_compression' in params:
            self.enable_http_compression = params["enable_http_compression"]


             
        self.refresh_chart_cache = refresh_chart_cache
        if 'refresh_chart_cache' in params:
            self.refresh_chart_cache = params["refresh_chart_cache"]


             
        self.sort_names = sort_names
        if 'sort_names' in params:
            self.sort_names = params["sort_names"]


             
        self.validate_merged_areas = validate_merged_areas
        if 'validate_merged_areas' in params:
            self.validate_merged_areas = params["validate_merged_areas"]


             

    @property
    def attached_files_directory(self):
        return self.container['attached_files_directory']

    @attached_files_directory.setter
    def attached_files_directory(self, attached_files_directory):
        self.container['attached_files_directory'] = attached_files_directory 
    @property
    def attached_files_url_prefix(self):
        return self.container['attached_files_url_prefix']

    @attached_files_url_prefix.setter
    def attached_files_url_prefix(self, attached_files_url_prefix):
        self.container['attached_files_url_prefix'] = attached_files_url_prefix 
    @property
    def encoding(self):
        return self.container['encoding']

    @encoding.setter
    def encoding(self, encoding):
        self.container['encoding'] = encoding 
    @property
    def export_active_worksheet_only(self):
        return self.container['export_active_worksheet_only']

    @export_active_worksheet_only.setter
    def export_active_worksheet_only(self, export_active_worksheet_only):
        self.container['export_active_worksheet_only'] = export_active_worksheet_only 
    @property
    def export_chart_image_format(self):
        return self.container['export_chart_image_format']

    @export_chart_image_format.setter
    def export_chart_image_format(self, export_chart_image_format):
        self.container['export_chart_image_format'] = export_chart_image_format 
    @property
    def export_images_as_base64(self):
        return self.container['export_images_as_base64']

    @export_images_as_base64.setter
    def export_images_as_base64(self, export_images_as_base64):
        self.container['export_images_as_base64'] = export_images_as_base64 
    @property
    def hidden_col_display_type(self):
        return self.container['hidden_col_display_type']

    @hidden_col_display_type.setter
    def hidden_col_display_type(self, hidden_col_display_type):
        self.container['hidden_col_display_type'] = hidden_col_display_type 
    @property
    def hidden_row_display_type(self):
        return self.container['hidden_row_display_type']

    @hidden_row_display_type.setter
    def hidden_row_display_type(self, hidden_row_display_type):
        self.container['hidden_row_display_type'] = hidden_row_display_type 
    @property
    def html_cross_string_type(self):
        return self.container['html_cross_string_type']

    @html_cross_string_type.setter
    def html_cross_string_type(self, html_cross_string_type):
        self.container['html_cross_string_type'] = html_cross_string_type 
    @property
    def is_exp_image_to_temp_dir(self):
        return self.container['is_exp_image_to_temp_dir']

    @is_exp_image_to_temp_dir.setter
    def is_exp_image_to_temp_dir(self, is_exp_image_to_temp_dir):
        self.container['is_exp_image_to_temp_dir'] = is_exp_image_to_temp_dir 
    @property
    def page_title(self):
        return self.container['page_title']

    @page_title.setter
    def page_title(self, page_title):
        self.container['page_title'] = page_title 
    @property
    def parse_html_tag_in_cell(self):
        return self.container['parse_html_tag_in_cell']

    @parse_html_tag_in_cell.setter
    def parse_html_tag_in_cell(self, parse_html_tag_in_cell):
        self.container['parse_html_tag_in_cell'] = parse_html_tag_in_cell 
    @property
    def save_format(self):
        return self.container['save_format']

    @save_format.setter
    def save_format(self, save_format):
        self.container['save_format'] = save_format 
    @property
    def cached_file_folder(self):
        return self.container['cached_file_folder']

    @cached_file_folder.setter
    def cached_file_folder(self, cached_file_folder):
        self.container['cached_file_folder'] = cached_file_folder 
    @property
    def clear_data(self):
        return self.container['clear_data']

    @clear_data.setter
    def clear_data(self, clear_data):
        self.container['clear_data'] = clear_data 
    @property
    def create_directory(self):
        return self.container['create_directory']

    @create_directory.setter
    def create_directory(self, create_directory):
        self.container['create_directory'] = create_directory 
    @property
    def enable_http_compression(self):
        return self.container['enable_http_compression']

    @enable_http_compression.setter
    def enable_http_compression(self, enable_http_compression):
        self.container['enable_http_compression'] = enable_http_compression 
    @property
    def refresh_chart_cache(self):
        return self.container['refresh_chart_cache']

    @refresh_chart_cache.setter
    def refresh_chart_cache(self, refresh_chart_cache):
        self.container['refresh_chart_cache'] = refresh_chart_cache 
    @property
    def sort_names(self):
        return self.container['sort_names']

    @sort_names.setter
    def sort_names(self, sort_names):
        self.container['sort_names'] = sort_names 
    @property
    def validate_merged_areas(self):
        return self.container['validate_merged_areas']

    @validate_merged_areas.setter
    def validate_merged_areas(self, validate_merged_areas):
        self.container['validate_merged_areas'] = validate_merged_areas 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, MHtmlSaveOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    