# coding: utf-8
"""
<copyright company="Aspose" file="Linepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Line(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'begin_arrow_length' : 'str',
        'begin_arrow_width' : 'str',
        'begin_type' : 'str',
        'cap_type' : 'str',
        'color' : 'Color',
        'compound_type' : 'str',
        'dash_type' : 'str',
        'end_arrow_length' : 'str',
        'end_arrow_width' : 'str',
        'end_type' : 'str',
        'gradient_fill' : 'GradientFill',
        'is_auto' : 'bool',
        'is_automatic_color' : 'bool',
        'is_visible' : 'bool',
        'join_type' : 'str',
        'style' : 'str',
        'transparency' : 'float',
        'weight' : 'str',
        'weight_pt' : 'float'
    }

    attribute_map = {
        'begin_arrow_length' : 'BeginArrowLength' ,
        'begin_arrow_width' : 'BeginArrowWidth' ,
        'begin_type' : 'BeginType' ,
        'cap_type' : 'CapType' ,
        'color' : 'Color' ,
        'compound_type' : 'CompoundType' ,
        'dash_type' : 'DashType' ,
        'end_arrow_length' : 'EndArrowLength' ,
        'end_arrow_width' : 'EndArrowWidth' ,
        'end_type' : 'EndType' ,
        'gradient_fill' : 'GradientFill' ,
        'is_auto' : 'IsAuto' ,
        'is_automatic_color' : 'IsAutomaticColor' ,
        'is_visible' : 'IsVisible' ,
        'join_type' : 'JoinType' ,
        'style' : 'Style' ,
        'transparency' : 'Transparency' ,
        'weight' : 'Weight' ,
        'weight_pt' : 'WeightPt' 
    }

    @staticmethod
    def get_swagger_types():
        return Line.swagger_types

    @staticmethod
    def get_attribute_map():
        return Line.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,begin_arrow_length=None ,begin_arrow_width=None ,begin_type=None ,cap_type=None ,color=None ,compound_type=None ,dash_type=None ,end_arrow_length=None ,end_arrow_width=None ,end_type=None ,gradient_fill=None ,is_auto=None ,is_automatic_color=None ,is_visible=None ,join_type=None ,style=None ,transparency=None ,weight=None ,weight_pt=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Line - a model defined in Swagger
        """
        self.container['begin_arrow_length'] = None 
        self.container['begin_arrow_width'] = None 
        self.container['begin_type'] = None 
        self.container['cap_type'] = None 
        self.container['color'] = None 
        self.container['compound_type'] = None 
        self.container['dash_type'] = None 
        self.container['end_arrow_length'] = None 
        self.container['end_arrow_width'] = None 
        self.container['end_type'] = None 
        self.container['gradient_fill'] = None 
        self.container['is_auto'] = None 
        self.container['is_automatic_color'] = None 
        self.container['is_visible'] = None 
        self.container['join_type'] = None 
        self.container['style'] = None 
        self.container['transparency'] = None 
        self.container['weight'] = None 
        self.container['weight_pt'] = None 
        params = locals()
        self.begin_arrow_length = begin_arrow_length
        if 'begin_arrow_length' in params:
            self.begin_arrow_length = params["begin_arrow_length"]


             
        self.begin_arrow_width = begin_arrow_width
        if 'begin_arrow_width' in params:
            self.begin_arrow_width = params["begin_arrow_width"]


             
        self.begin_type = begin_type
        if 'begin_type' in params:
            self.begin_type = params["begin_type"]


             
        self.cap_type = cap_type
        if 'cap_type' in params:
            self.cap_type = params["cap_type"]


             
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.compound_type = compound_type
        if 'compound_type' in params:
            self.compound_type = params["compound_type"]


             
        self.dash_type = dash_type
        if 'dash_type' in params:
            self.dash_type = params["dash_type"]


             
        self.end_arrow_length = end_arrow_length
        if 'end_arrow_length' in params:
            self.end_arrow_length = params["end_arrow_length"]


             
        self.end_arrow_width = end_arrow_width
        if 'end_arrow_width' in params:
            self.end_arrow_width = params["end_arrow_width"]


             
        self.end_type = end_type
        if 'end_type' in params:
            self.end_type = params["end_type"]


             
        self.gradient_fill = gradient_fill
        if 'gradient_fill' in params:
            self.gradient_fill = params["gradient_fill"]


             
        self.is_auto = is_auto
        if 'is_auto' in params:
            self.is_auto = params["is_auto"]


             
        self.is_automatic_color = is_automatic_color
        if 'is_automatic_color' in params:
            self.is_automatic_color = params["is_automatic_color"]


             
        self.is_visible = is_visible
        if 'is_visible' in params:
            self.is_visible = params["is_visible"]


             
        self.join_type = join_type
        if 'join_type' in params:
            self.join_type = params["join_type"]


             
        self.style = style
        if 'style' in params:
            self.style = params["style"]


             
        self.transparency = transparency
        if 'transparency' in params:
            self.transparency = params["transparency"]


             
        self.weight = weight
        if 'weight' in params:
            self.weight = params["weight"]


             
        self.weight_pt = weight_pt
        if 'weight_pt' in params:
            self.weight_pt = params["weight_pt"]


             

    @property
    def begin_arrow_length(self):
        return self.container['begin_arrow_length']

    @begin_arrow_length.setter
    def begin_arrow_length(self, begin_arrow_length):
        self.container['begin_arrow_length'] = begin_arrow_length 
    @property
    def begin_arrow_width(self):
        return self.container['begin_arrow_width']

    @begin_arrow_width.setter
    def begin_arrow_width(self, begin_arrow_width):
        self.container['begin_arrow_width'] = begin_arrow_width 
    @property
    def begin_type(self):
        return self.container['begin_type']

    @begin_type.setter
    def begin_type(self, begin_type):
        self.container['begin_type'] = begin_type 
    @property
    def cap_type(self):
        return self.container['cap_type']

    @cap_type.setter
    def cap_type(self, cap_type):
        self.container['cap_type'] = cap_type 
    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def compound_type(self):
        return self.container['compound_type']

    @compound_type.setter
    def compound_type(self, compound_type):
        self.container['compound_type'] = compound_type 
    @property
    def dash_type(self):
        return self.container['dash_type']

    @dash_type.setter
    def dash_type(self, dash_type):
        self.container['dash_type'] = dash_type 
    @property
    def end_arrow_length(self):
        return self.container['end_arrow_length']

    @end_arrow_length.setter
    def end_arrow_length(self, end_arrow_length):
        self.container['end_arrow_length'] = end_arrow_length 
    @property
    def end_arrow_width(self):
        return self.container['end_arrow_width']

    @end_arrow_width.setter
    def end_arrow_width(self, end_arrow_width):
        self.container['end_arrow_width'] = end_arrow_width 
    @property
    def end_type(self):
        return self.container['end_type']

    @end_type.setter
    def end_type(self, end_type):
        self.container['end_type'] = end_type 
    @property
    def gradient_fill(self):
        return self.container['gradient_fill']

    @gradient_fill.setter
    def gradient_fill(self, gradient_fill):
        self.container['gradient_fill'] = gradient_fill 
    @property
    def is_auto(self):
        return self.container['is_auto']

    @is_auto.setter
    def is_auto(self, is_auto):
        self.container['is_auto'] = is_auto 
    @property
    def is_automatic_color(self):
        return self.container['is_automatic_color']

    @is_automatic_color.setter
    def is_automatic_color(self, is_automatic_color):
        self.container['is_automatic_color'] = is_automatic_color 
    @property
    def is_visible(self):
        return self.container['is_visible']

    @is_visible.setter
    def is_visible(self, is_visible):
        self.container['is_visible'] = is_visible 
    @property
    def join_type(self):
        return self.container['join_type']

    @join_type.setter
    def join_type(self, join_type):
        self.container['join_type'] = join_type 
    @property
    def style(self):
        return self.container['style']

    @style.setter
    def style(self, style):
        self.container['style'] = style 
    @property
    def transparency(self):
        return self.container['transparency']

    @transparency.setter
    def transparency(self, transparency):
        self.container['transparency'] = transparency 
    @property
    def weight(self):
        return self.container['weight']

    @weight.setter
    def weight(self, weight):
        self.container['weight'] = weight 
    @property
    def weight_pt(self):
        return self.container['weight_pt']

    @weight_pt.setter
    def weight_pt(self, weight_pt):
        self.container['weight_pt'] = weight_pt 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Line):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    