# coding: utf-8
"""
<copyright company="Aspose" file="FontSettingpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class FontSetting(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'font' : 'Font',
        'length' : 'int',
        'start_index' : 'int',
        'text_options' : 'TextOptions',
        'type' : 'str'
    }

    attribute_map = {
        'font' : 'Font' ,
        'length' : 'Length' ,
        'start_index' : 'StartIndex' ,
        'text_options' : 'TextOptions' ,
        'type' : 'Type' 
    }

    @staticmethod
    def get_swagger_types():
        return FontSetting.swagger_types

    @staticmethod
    def get_attribute_map():
        return FontSetting.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,font=None ,length=None ,start_index=None ,text_options=None ,type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        FontSetting - a model defined in Swagger
        """
        self.container['font'] = None 
        self.container['length'] = None 
        self.container['start_index'] = None 
        self.container['text_options'] = None 
        self.container['type'] = None 
        params = locals()
        self.font = font
        if 'font' in params:
            self.font = params["font"]


             
        self.length = length
        if 'length' in params:
            self.length = params["length"]


             
        self.start_index = start_index
        if 'start_index' in params:
            self.start_index = params["start_index"]


             
        self.text_options = text_options
        if 'text_options' in params:
            self.text_options = params["text_options"]


             
        self.type = type
        if 'type' in params:
            self.type = params["type"]


             

    @property
    def font(self):
        return self.container['font']

    @font.setter
    def font(self, font):
        self.container['font'] = font 
    @property
    def length(self):
        return self.container['length']

    @length.setter
    def length(self, length):
        self.container['length'] = length 
    @property
    def start_index(self):
        return self.container['start_index']

    @start_index.setter
    def start_index(self, start_index):
        self.container['start_index'] = start_index 
    @property
    def text_options(self):
        return self.container['text_options']

    @text_options.setter
    def text_options(self, text_options):
        self.container['text_options'] = text_options 
    @property
    def type(self):
        return self.container['type']

    @type.setter
    def type(self, type):
        self.container['type'] = type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FontSetting):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    