# coding: utf-8
"""
<copyright company="Aspose" file="Fontpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Font(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'color' : 'Color',
        'double_size' : 'float',
        'is_bold' : 'bool',
        'is_italic' : 'bool',
        'is_strikeout' : 'bool',
        'is_subscript' : 'bool',
        'is_superscript' : 'bool',
        'name' : 'str',
        'size' : 'int',
        'underline' : 'str'
    }

    attribute_map = {
        'color' : 'Color' ,
        'double_size' : 'DoubleSize' ,
        'is_bold' : 'IsBold' ,
        'is_italic' : 'IsItalic' ,
        'is_strikeout' : 'IsStrikeout' ,
        'is_subscript' : 'IsSubscript' ,
        'is_superscript' : 'IsSuperscript' ,
        'name' : 'Name' ,
        'size' : 'Size' ,
        'underline' : 'Underline' 
    }

    @staticmethod
    def get_swagger_types():
        return Font.swagger_types

    @staticmethod
    def get_attribute_map():
        return Font.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,color=None ,double_size=None ,is_bold=None ,is_italic=None ,is_strikeout=None ,is_subscript=None ,is_superscript=None ,name=None ,size=None ,underline=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Font - a model defined in Swagger
        """
        self.container['color'] = None 
        self.container['double_size'] = None 
        self.container['is_bold'] = None 
        self.container['is_italic'] = None 
        self.container['is_strikeout'] = None 
        self.container['is_subscript'] = None 
        self.container['is_superscript'] = None 
        self.container['name'] = None 
        self.container['size'] = None 
        self.container['underline'] = None 
        params = locals()
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.double_size = double_size
        if 'double_size' in params:
            self.double_size = params["double_size"]


             
        self.is_bold = is_bold
        if 'is_bold' in params:
            self.is_bold = params["is_bold"]


             
        self.is_italic = is_italic
        if 'is_italic' in params:
            self.is_italic = params["is_italic"]


             
        self.is_strikeout = is_strikeout
        if 'is_strikeout' in params:
            self.is_strikeout = params["is_strikeout"]


             
        self.is_subscript = is_subscript
        if 'is_subscript' in params:
            self.is_subscript = params["is_subscript"]


             
        self.is_superscript = is_superscript
        if 'is_superscript' in params:
            self.is_superscript = params["is_superscript"]


             
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.size = size
        if 'size' in params:
            self.size = params["size"]


             
        self.underline = underline
        if 'underline' in params:
            self.underline = params["underline"]


             

    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def double_size(self):
        return self.container['double_size']

    @double_size.setter
    def double_size(self, double_size):
        self.container['double_size'] = double_size 
    @property
    def is_bold(self):
        return self.container['is_bold']

    @is_bold.setter
    def is_bold(self, is_bold):
        self.container['is_bold'] = is_bold 
    @property
    def is_italic(self):
        return self.container['is_italic']

    @is_italic.setter
    def is_italic(self, is_italic):
        self.container['is_italic'] = is_italic 
    @property
    def is_strikeout(self):
        return self.container['is_strikeout']

    @is_strikeout.setter
    def is_strikeout(self, is_strikeout):
        self.container['is_strikeout'] = is_strikeout 
    @property
    def is_subscript(self):
        return self.container['is_subscript']

    @is_subscript.setter
    def is_subscript(self, is_subscript):
        self.container['is_subscript'] = is_subscript 
    @property
    def is_superscript(self):
        return self.container['is_superscript']

    @is_superscript.setter
    def is_superscript(self, is_superscript):
        self.container['is_superscript'] = is_superscript 
    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def size(self):
        return self.container['size']

    @size.setter
    def size(self, size):
        self.container['size'] = size 
    @property
    def underline(self):
        return self.container['underline']

    @underline.setter
    def underline(self, underline):
        self.container['underline'] = underline 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Font):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    