# coding: utf-8
"""
<copyright company="Aspose" file="Floorpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Floor(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'border' : 'Line',
        'background_color' : 'Color',
        'fill_format' : 'FillFormat',
        'foreground_color' : 'Color',
        'format' : 'str',
        'invert_if_negative' : 'bool',
        'transparency' : 'float'
    }

    attribute_map = {
        'border' : 'Border' ,
        'background_color' : 'BackgroundColor' ,
        'fill_format' : 'FillFormat' ,
        'foreground_color' : 'ForegroundColor' ,
        'format' : 'Format' ,
        'invert_if_negative' : 'InvertIfNegative' ,
        'transparency' : 'Transparency' 
    }

    @staticmethod
    def get_swagger_types():
        return Floor.swagger_types

    @staticmethod
    def get_attribute_map():
        return Floor.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,border=None ,background_color=None ,fill_format=None ,foreground_color=None ,format=None ,invert_if_negative=None ,transparency=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Floor - a model defined in Swagger
        """
        self.container['border'] = None 
        self.container['background_color'] = None 
        self.container['fill_format'] = None 
        self.container['foreground_color'] = None 
        self.container['format'] = None 
        self.container['invert_if_negative'] = None 
        self.container['transparency'] = None 
        params = locals()
        self.border = border
        if 'border' in params:
            self.border = params["border"]


             
        self.background_color = background_color
        if 'background_color' in params:
            self.background_color = params["background_color"]


             
        self.fill_format = fill_format
        if 'fill_format' in params:
            self.fill_format = params["fill_format"]


             
        self.foreground_color = foreground_color
        if 'foreground_color' in params:
            self.foreground_color = params["foreground_color"]


             
        self.format = format
        if 'format' in params:
            self.format = params["format"]


             
        self.invert_if_negative = invert_if_negative
        if 'invert_if_negative' in params:
            self.invert_if_negative = params["invert_if_negative"]


             
        self.transparency = transparency
        if 'transparency' in params:
            self.transparency = params["transparency"]


             

    @property
    def border(self):
        return self.container['border']

    @border.setter
    def border(self, border):
        self.container['border'] = border 
    @property
    def background_color(self):
        return self.container['background_color']

    @background_color.setter
    def background_color(self, background_color):
        self.container['background_color'] = background_color 
    @property
    def fill_format(self):
        return self.container['fill_format']

    @fill_format.setter
    def fill_format(self, fill_format):
        self.container['fill_format'] = fill_format 
    @property
    def foreground_color(self):
        return self.container['foreground_color']

    @foreground_color.setter
    def foreground_color(self, foreground_color):
        self.container['foreground_color'] = foreground_color 
    @property
    def format(self):
        return self.container['format']

    @format.setter
    def format(self, format):
        self.container['format'] = format 
    @property
    def invert_if_negative(self):
        return self.container['invert_if_negative']

    @invert_if_negative.setter
    def invert_if_negative(self, invert_if_negative):
        self.container['invert_if_negative'] = invert_if_negative 
    @property
    def transparency(self):
        return self.container['transparency']

    @transparency.setter
    def transparency(self, transparency):
        self.container['transparency'] = transparency 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Floor):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    