# coding: utf-8
"""
<copyright company="Aspose" file="ExtractTextOptionspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ExtractTextOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'data_source' : 'DataSource',
        'file_info' : 'FileInfo',
        'worksheet' : 'str',
        'range' : 'str',
        'extract_text_type' : 'str',
        'before_text' : 'str',
        'after_text' : 'str',
        'before_position' : 'int',
        'after_position' : 'int',
        'out_position_range' : 'str'
    }

    attribute_map = {
        'name' : 'Name' ,
        'data_source' : 'DataSource' ,
        'file_info' : 'FileInfo' ,
        'worksheet' : 'Worksheet' ,
        'range' : 'Range' ,
        'extract_text_type' : 'ExtractTextType' ,
        'before_text' : 'BeforeText' ,
        'after_text' : 'AfterText' ,
        'before_position' : 'BeforePosition' ,
        'after_position' : 'AfterPosition' ,
        'out_position_range' : 'OutPositionRange' 
    }

    @staticmethod
    def get_swagger_types():
        return ExtractTextOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return ExtractTextOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,data_source=None ,file_info=None ,worksheet=None ,range=None ,extract_text_type=None ,before_text=None ,after_text=None ,before_position=None ,after_position=None ,out_position_range=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ExtractTextOptions - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['data_source'] = None 
        self.container['file_info'] = None 
        self.container['worksheet'] = None 
        self.container['range'] = None 
        self.container['extract_text_type'] = None 
        self.container['before_text'] = None 
        self.container['after_text'] = None 
        self.container['before_position'] = None 
        self.container['after_position'] = None 
        self.container['out_position_range'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.file_info = file_info
        if 'file_info' in params:
            self.file_info = params["file_info"]


             
        self.worksheet = worksheet
        if 'worksheet' in params:
            self.worksheet = params["worksheet"]


             
        self.range = range
        if 'range' in params:
            self.range = params["range"]


             
        self.extract_text_type = extract_text_type
        if 'extract_text_type' in params:
            self.extract_text_type = params["extract_text_type"]


             
        self.before_text = before_text
        if 'before_text' in params:
            self.before_text = params["before_text"]


             
        self.after_text = after_text
        if 'after_text' in params:
            self.after_text = params["after_text"]


             
        self.before_position = before_position
        if 'before_position' in params:
            self.before_position = params["before_position"]


             
        self.after_position = after_position
        if 'after_position' in params:
            self.after_position = params["after_position"]


             
        self.out_position_range = out_position_range
        if 'out_position_range' in params:
            self.out_position_range = params["out_position_range"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def file_info(self):
        return self.container['file_info']

    @file_info.setter
    def file_info(self, file_info):
        self.container['file_info'] = file_info 
    @property
    def worksheet(self):
        return self.container['worksheet']

    @worksheet.setter
    def worksheet(self, worksheet):
        self.container['worksheet'] = worksheet 
    @property
    def range(self):
        return self.container['range']

    @range.setter
    def range(self, range):
        self.container['range'] = range 
    @property
    def extract_text_type(self):
        return self.container['extract_text_type']

    @extract_text_type.setter
    def extract_text_type(self, extract_text_type):
        self.container['extract_text_type'] = extract_text_type 
    @property
    def before_text(self):
        return self.container['before_text']

    @before_text.setter
    def before_text(self, before_text):
        self.container['before_text'] = before_text 
    @property
    def after_text(self):
        return self.container['after_text']

    @after_text.setter
    def after_text(self, after_text):
        self.container['after_text'] = after_text 
    @property
    def before_position(self):
        return self.container['before_position']

    @before_position.setter
    def before_position(self, before_position):
        self.container['before_position'] = before_position 
    @property
    def after_position(self):
        return self.container['after_position']

    @after_position.setter
    def after_position(self, after_position):
        self.container['after_position'] = after_position 
    @property
    def out_position_range(self):
        return self.container['out_position_range']

    @out_position_range.setter
    def out_position_range(self, out_position_range):
        self.container['out_position_range'] = out_position_range 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ExtractTextOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    