# coding: utf-8
"""
<copyright company="Aspose" file="DigitalSignaturepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DigitalSignature(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'comments' : 'str',
        'sign_time' : 'str',
        'id' : 'str',
        'password' : 'str',
        'image' : 'list[int]',
        'provider_id' : 'str',
        'is_valid' : 'bool',
        'x_ad_es_type' : 'str'
    }

    attribute_map = {
        'comments' : 'Comments' ,
        'sign_time' : 'SignTime' ,
        'id' : 'Id' ,
        'password' : 'Password' ,
        'image' : 'Image' ,
        'provider_id' : 'ProviderId' ,
        'is_valid' : 'IsValid' ,
        'x_ad_es_type' : 'XAdESType' 
    }

    @staticmethod
    def get_swagger_types():
        return DigitalSignature.swagger_types

    @staticmethod
    def get_attribute_map():
        return DigitalSignature.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,comments=None ,sign_time=None ,id=None ,password=None ,image=None ,provider_id=None ,is_valid=None ,x_ad_es_type=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DigitalSignature - a model defined in Swagger
        """
        self.container['comments'] = None 
        self.container['sign_time'] = None 
        self.container['id'] = None 
        self.container['password'] = None 
        self.container['image'] = None 
        self.container['provider_id'] = None 
        self.container['is_valid'] = None 
        self.container['x_ad_es_type'] = None 
        params = locals()
        self.comments = comments
        if 'comments' in params:
            self.comments = params["comments"]


             
        self.sign_time = sign_time
        if 'sign_time' in params:
            self.sign_time = params["sign_time"]


             
        self.id = id
        if 'id' in params:
            self.id = params["id"]


             
        self.password = password
        if 'password' in params:
            self.password = params["password"]


             
        self.image = image
        if 'image' in params:
            self.image = params["image"]


             
        self.provider_id = provider_id
        if 'provider_id' in params:
            self.provider_id = params["provider_id"]


             
        self.is_valid = is_valid
        if 'is_valid' in params:
            self.is_valid = params["is_valid"]


             
        self.x_ad_es_type = x_ad_es_type
        if 'x_ad_es_type' in params:
            self.x_ad_es_type = params["x_ad_es_type"]


             

    @property
    def comments(self):
        return self.container['comments']

    @comments.setter
    def comments(self, comments):
        self.container['comments'] = comments 
    @property
    def sign_time(self):
        return self.container['sign_time']

    @sign_time.setter
    def sign_time(self, sign_time):
        self.container['sign_time'] = sign_time 
    @property
    def id(self):
        return self.container['id']

    @id.setter
    def id(self, id):
        self.container['id'] = id 
    @property
    def password(self):
        return self.container['password']

    @password.setter
    def password(self, password):
        self.container['password'] = password 
    @property
    def image(self):
        return self.container['image']

    @image.setter
    def image(self, image):
        self.container['image'] = image 
    @property
    def provider_id(self):
        return self.container['provider_id']

    @provider_id.setter
    def provider_id(self, provider_id):
        self.container['provider_id'] = provider_id 
    @property
    def is_valid(self):
        return self.container['is_valid']

    @is_valid.setter
    def is_valid(self, is_valid):
        self.container['is_valid'] = is_valid 
    @property
    def x_ad_es_type(self):
        return self.container['x_ad_es_type']

    @x_ad_es_type.setter
    def x_ad_es_type(self, x_ad_es_type):
        self.container['x_ad_es_type'] = x_ad_es_type 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DigitalSignature):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    