# coding: utf-8
"""
<copyright company="Aspose" file="DateTimeGroupItempy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DateTimeGroupItem(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'date_time_grouping_type' : 'str',
        'day' : 'int',
        'hour' : 'int',
        'minute' : 'int',
        'month' : 'int',
        'second' : 'int',
        'year' : 'int'
    }

    attribute_map = {
        'date_time_grouping_type' : 'DateTimeGroupingType' ,
        'day' : 'Day' ,
        'hour' : 'Hour' ,
        'minute' : 'Minute' ,
        'month' : 'Month' ,
        'second' : 'Second' ,
        'year' : 'Year' 
    }

    @staticmethod
    def get_swagger_types():
        return DateTimeGroupItem.swagger_types

    @staticmethod
    def get_attribute_map():
        return DateTimeGroupItem.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,date_time_grouping_type=None ,day=None ,hour=None ,minute=None ,month=None ,second=None ,year=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DateTimeGroupItem - a model defined in Swagger
        """
        self.container['date_time_grouping_type'] = None 
        self.container['day'] = None 
        self.container['hour'] = None 
        self.container['minute'] = None 
        self.container['month'] = None 
        self.container['second'] = None 
        self.container['year'] = None 
        params = locals()
        self.date_time_grouping_type = date_time_grouping_type
        if 'date_time_grouping_type' in params:
            self.date_time_grouping_type = params["date_time_grouping_type"]


             
        self.day = day
        if 'day' in params:
            self.day = params["day"]


             
        self.hour = hour
        if 'hour' in params:
            self.hour = params["hour"]


             
        self.minute = minute
        if 'minute' in params:
            self.minute = params["minute"]


             
        self.month = month
        if 'month' in params:
            self.month = params["month"]


             
        self.second = second
        if 'second' in params:
            self.second = params["second"]


             
        self.year = year
        if 'year' in params:
            self.year = params["year"]


             

    @property
    def date_time_grouping_type(self):
        return self.container['date_time_grouping_type']

    @date_time_grouping_type.setter
    def date_time_grouping_type(self, date_time_grouping_type):
        self.container['date_time_grouping_type'] = date_time_grouping_type 
    @property
    def day(self):
        return self.container['day']

    @day.setter
    def day(self, day):
        self.container['day'] = day 
    @property
    def hour(self):
        return self.container['hour']

    @hour.setter
    def hour(self, hour):
        self.container['hour'] = hour 
    @property
    def minute(self):
        return self.container['minute']

    @minute.setter
    def minute(self, minute):
        self.container['minute'] = minute 
    @property
    def month(self):
        return self.container['month']

    @month.setter
    def month(self, month):
        self.container['month'] = month 
    @property
    def second(self):
        return self.container['second']

    @second.setter
    def second(self, second):
        self.container['second'] = second 
    @property
    def year(self):
        return self.container['year']

    @year.setter
    def year(self, year):
        self.container['year'] = year 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DateTimeGroupItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    