# coding: utf-8
"""
<copyright company="Aspose" file="DataSorterpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DataSorter(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'case_sensitive' : 'bool',
        'has_headers' : 'bool',
        'key_list' : 'list[SortKey]',
        'sort_left_to_right' : 'bool',
        'sort_as_number' : 'bool',
        'keys' : 'list[DataSorterKey]'
    }

    attribute_map = {
        'case_sensitive' : 'CaseSensitive' ,
        'has_headers' : 'HasHeaders' ,
        'key_list' : 'KeyList' ,
        'sort_left_to_right' : 'SortLeftToRight' ,
        'sort_as_number' : 'SortAsNumber' ,
        'keys' : 'Keys' 
    }

    @staticmethod
    def get_swagger_types():
        return DataSorter.swagger_types

    @staticmethod
    def get_attribute_map():
        return DataSorter.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,case_sensitive=None ,has_headers=None ,key_list=None ,sort_left_to_right=None ,sort_as_number=None ,keys=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DataSorter - a model defined in Swagger
        """
        self.container['case_sensitive'] = None 
        self.container['has_headers'] = None 
        self.container['key_list'] = None 
        self.container['sort_left_to_right'] = None 
        self.container['sort_as_number'] = None 
        self.container['keys'] = None 
        params = locals()
        self.case_sensitive = case_sensitive
        if 'case_sensitive' in params:
            self.case_sensitive = params["case_sensitive"]


             
        self.has_headers = has_headers
        if 'has_headers' in params:
            self.has_headers = params["has_headers"]


             
        self.key_list = key_list
        if 'key_list' in params:
            self.key_list = params["key_list"]


             
        self.sort_left_to_right = sort_left_to_right
        if 'sort_left_to_right' in params:
            self.sort_left_to_right = params["sort_left_to_right"]


             
        self.sort_as_number = sort_as_number
        if 'sort_as_number' in params:
            self.sort_as_number = params["sort_as_number"]


             
        self.keys = keys
        if 'keys' in params:
            self.keys = params["keys"]


             

    @property
    def case_sensitive(self):
        return self.container['case_sensitive']

    @case_sensitive.setter
    def case_sensitive(self, case_sensitive):
        self.container['case_sensitive'] = case_sensitive 
    @property
    def has_headers(self):
        return self.container['has_headers']

    @has_headers.setter
    def has_headers(self, has_headers):
        self.container['has_headers'] = has_headers 
    @property
    def key_list(self):
        return self.container['key_list']

    @key_list.setter
    def key_list(self, key_list):
        self.container['key_list'] = key_list 
    @property
    def sort_left_to_right(self):
        return self.container['sort_left_to_right']

    @sort_left_to_right.setter
    def sort_left_to_right(self, sort_left_to_right):
        self.container['sort_left_to_right'] = sort_left_to_right 
    @property
    def sort_as_number(self):
        return self.container['sort_as_number']

    @sort_as_number.setter
    def sort_as_number(self, sort_as_number):
        self.container['sort_as_number'] = sort_as_number 
    @property
    def keys(self):
        return self.container['keys']

    @keys.setter
    def keys(self, keys):
        self.container['keys'] = keys 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataSorter):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    