# coding: utf-8
"""
<copyright company="Aspose" file="DataFillValuepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DataFillValue(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'default_boolean' : 'bool',
        'default_string' : 'str',
        'default_number' : 'int',
        'default_double' : 'float',
        'default_date' : 'str'
    }

    attribute_map = {
        'default_boolean' : 'DefaultBoolean' ,
        'default_string' : 'DefaultString' ,
        'default_number' : 'DefaultNumber' ,
        'default_double' : 'DefaultDouble' ,
        'default_date' : 'DefaultDate' 
    }

    @staticmethod
    def get_swagger_types():
        return DataFillValue.swagger_types

    @staticmethod
    def get_attribute_map():
        return DataFillValue.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,default_boolean=None ,default_string=None ,default_number=None ,default_double=None ,default_date=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DataFillValue - a model defined in Swagger
        """
        self.container['default_boolean'] = None 
        self.container['default_string'] = None 
        self.container['default_number'] = None 
        self.container['default_double'] = None 
        self.container['default_date'] = None 
        params = locals()
        self.default_boolean = default_boolean
        if 'default_boolean' in params:
            self.default_boolean = params["default_boolean"]


             
        self.default_string = default_string
        if 'default_string' in params:
            self.default_string = params["default_string"]


             
        self.default_number = default_number
        if 'default_number' in params:
            self.default_number = params["default_number"]


             
        self.default_double = default_double
        if 'default_double' in params:
            self.default_double = params["default_double"]


             
        self.default_date = default_date
        if 'default_date' in params:
            self.default_date = params["default_date"]


             

    @property
    def default_boolean(self):
        return self.container['default_boolean']

    @default_boolean.setter
    def default_boolean(self, default_boolean):
        self.container['default_boolean'] = default_boolean 
    @property
    def default_string(self):
        return self.container['default_string']

    @default_string.setter
    def default_string(self, default_string):
        self.container['default_string'] = default_string 
    @property
    def default_number(self):
        return self.container['default_number']

    @default_number.setter
    def default_number(self, default_number):
        self.container['default_number'] = default_number 
    @property
    def default_double(self):
        return self.container['default_double']

    @default_double.setter
    def default_double(self, default_double):
        self.container['default_double'] = default_double 
    @property
    def default_date(self):
        return self.container['default_date']

    @default_date.setter
    def default_date(self, default_date):
        self.container['default_date'] = default_date 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataFillValue):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    