# coding: utf-8
"""
<copyright company="Aspose" file="DataDeduplicationRequestpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DataDeduplicationRequest(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'file' : 'FileInfo',
        'deduplication_region' : 'DeduplicationRegion',
        'out_file_format' : 'str',
        'check_excel_restriction' : 'bool',
        'region' : 'str'
    }

    attribute_map = {
        'file' : 'File' ,
        'deduplication_region' : 'DeduplicationRegion' ,
        'out_file_format' : 'OutFileFormat' ,
        'check_excel_restriction' : 'CheckExcelRestriction' ,
        'region' : 'Region' 
    }

    @staticmethod
    def get_swagger_types():
        return DataDeduplicationRequest.swagger_types

    @staticmethod
    def get_attribute_map():
        return DataDeduplicationRequest.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,file=None ,deduplication_region=None ,out_file_format=None ,check_excel_restriction=None ,region=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DataDeduplicationRequest - a model defined in Swagger
        """
        self.container['file'] = None 
        self.container['deduplication_region'] = None 
        self.container['out_file_format'] = None 
        self.container['check_excel_restriction'] = None 
        self.container['region'] = None 
        params = locals()
        self.file = file
        if 'file' in params:
            self.file = params["file"]


             
        self.deduplication_region = deduplication_region
        if 'deduplication_region' in params:
            self.deduplication_region = params["deduplication_region"]


             
        self.out_file_format = out_file_format
        if 'out_file_format' in params:
            self.out_file_format = params["out_file_format"]


             
        self.check_excel_restriction = check_excel_restriction
        if 'check_excel_restriction' in params:
            self.check_excel_restriction = params["check_excel_restriction"]


             
        self.region = region
        if 'region' in params:
            self.region = params["region"]


             

    @property
    def file(self):
        return self.container['file']

    @file.setter
    def file(self, file):
        self.container['file'] = file 
    @property
    def deduplication_region(self):
        return self.container['deduplication_region']

    @deduplication_region.setter
    def deduplication_region(self, deduplication_region):
        self.container['deduplication_region'] = deduplication_region 
    @property
    def out_file_format(self):
        return self.container['out_file_format']

    @out_file_format.setter
    def out_file_format(self, out_file_format):
        self.container['out_file_format'] = out_file_format 
    @property
    def check_excel_restriction(self):
        return self.container['check_excel_restriction']

    @check_excel_restriction.setter
    def check_excel_restriction(self, check_excel_restriction):
        self.container['check_excel_restriction'] = check_excel_restriction 
    @property
    def region(self):
        return self.container['region']

    @region.setter
    def region(self, region):
        self.container['region'] = region 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataDeduplicationRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    