# coding: utf-8
"""
<copyright company="Aspose" file="DataCleansingpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DataCleansing(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'ranges' : 'list[Range]',
        'need_fill_data' : 'bool',
        'data_fill' : 'DataFill'
    }

    attribute_map = {
        'ranges' : 'Ranges' ,
        'need_fill_data' : 'NeedFillData' ,
        'data_fill' : 'DataFill' 
    }

    @staticmethod
    def get_swagger_types():
        return DataCleansing.swagger_types

    @staticmethod
    def get_attribute_map():
        return DataCleansing.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,ranges=None ,need_fill_data=None ,data_fill=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DataCleansing - a model defined in Swagger
        """
        self.container['ranges'] = None 
        self.container['need_fill_data'] = None 
        self.container['data_fill'] = None 
        params = locals()
        self.ranges = ranges
        if 'ranges' in params:
            self.ranges = params["ranges"]


             
        self.need_fill_data = need_fill_data
        if 'need_fill_data' in params:
            self.need_fill_data = params["need_fill_data"]


             
        self.data_fill = data_fill
        if 'data_fill' in params:
            self.data_fill = params["data_fill"]


             

    @property
    def ranges(self):
        return self.container['ranges']

    @ranges.setter
    def ranges(self, ranges):
        self.container['ranges'] = ranges 
    @property
    def need_fill_data(self):
        return self.container['need_fill_data']

    @need_fill_data.setter
    def need_fill_data(self, need_fill_data):
        self.container['need_fill_data'] = need_fill_data 
    @property
    def data_fill(self):
        return self.container['data_fill']

    @data_fill.setter
    def data_fill(self, data_fill):
        self.container['data_fill'] = data_fill 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataCleansing):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    