# coding: utf-8
"""
<copyright company="Aspose" file="DataBarpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class DataBar(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'axis_color' : 'Color',
        'axis_position' : 'str',
        'bar_border' : 'DataBarBorder',
        'bar_fill_type' : 'str',
        'color' : 'Color',
        'direction' : 'str',
        'max_cfvo' : 'ConditionalFormattingValue',
        'max_length' : 'int',
        'min_cfvo' : 'ConditionalFormattingValue',
        'min_length' : 'int',
        'negative_bar_format' : 'NegativeBarFormat',
        'show_value' : 'bool'
    }

    attribute_map = {
        'axis_color' : 'AxisColor' ,
        'axis_position' : 'AxisPosition' ,
        'bar_border' : 'BarBorder' ,
        'bar_fill_type' : 'BarFillType' ,
        'color' : 'Color' ,
        'direction' : 'Direction' ,
        'max_cfvo' : 'MaxCfvo' ,
        'max_length' : 'MaxLength' ,
        'min_cfvo' : 'MinCfvo' ,
        'min_length' : 'MinLength' ,
        'negative_bar_format' : 'NegativeBarFormat' ,
        'show_value' : 'ShowValue' 
    }

    @staticmethod
    def get_swagger_types():
        return DataBar.swagger_types

    @staticmethod
    def get_attribute_map():
        return DataBar.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,axis_color=None ,axis_position=None ,bar_border=None ,bar_fill_type=None ,color=None ,direction=None ,max_cfvo=None ,max_length=None ,min_cfvo=None ,min_length=None ,negative_bar_format=None ,show_value=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        DataBar - a model defined in Swagger
        """
        self.container['axis_color'] = None 
        self.container['axis_position'] = None 
        self.container['bar_border'] = None 
        self.container['bar_fill_type'] = None 
        self.container['color'] = None 
        self.container['direction'] = None 
        self.container['max_cfvo'] = None 
        self.container['max_length'] = None 
        self.container['min_cfvo'] = None 
        self.container['min_length'] = None 
        self.container['negative_bar_format'] = None 
        self.container['show_value'] = None 
        params = locals()
        self.axis_color = axis_color
        if 'axis_color' in params:
            self.axis_color = params["axis_color"]


             
        self.axis_position = axis_position
        if 'axis_position' in params:
            self.axis_position = params["axis_position"]


             
        self.bar_border = bar_border
        if 'bar_border' in params:
            self.bar_border = params["bar_border"]


             
        self.bar_fill_type = bar_fill_type
        if 'bar_fill_type' in params:
            self.bar_fill_type = params["bar_fill_type"]


             
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.direction = direction
        if 'direction' in params:
            self.direction = params["direction"]


             
        self.max_cfvo = max_cfvo
        if 'max_cfvo' in params:
            self.max_cfvo = params["max_cfvo"]


             
        self.max_length = max_length
        if 'max_length' in params:
            self.max_length = params["max_length"]


             
        self.min_cfvo = min_cfvo
        if 'min_cfvo' in params:
            self.min_cfvo = params["min_cfvo"]


             
        self.min_length = min_length
        if 'min_length' in params:
            self.min_length = params["min_length"]


             
        self.negative_bar_format = negative_bar_format
        if 'negative_bar_format' in params:
            self.negative_bar_format = params["negative_bar_format"]


             
        self.show_value = show_value
        if 'show_value' in params:
            self.show_value = params["show_value"]


             

    @property
    def axis_color(self):
        return self.container['axis_color']

    @axis_color.setter
    def axis_color(self, axis_color):
        self.container['axis_color'] = axis_color 
    @property
    def axis_position(self):
        return self.container['axis_position']

    @axis_position.setter
    def axis_position(self, axis_position):
        self.container['axis_position'] = axis_position 
    @property
    def bar_border(self):
        return self.container['bar_border']

    @bar_border.setter
    def bar_border(self, bar_border):
        self.container['bar_border'] = bar_border 
    @property
    def bar_fill_type(self):
        return self.container['bar_fill_type']

    @bar_fill_type.setter
    def bar_fill_type(self, bar_fill_type):
        self.container['bar_fill_type'] = bar_fill_type 
    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def direction(self):
        return self.container['direction']

    @direction.setter
    def direction(self, direction):
        self.container['direction'] = direction 
    @property
    def max_cfvo(self):
        return self.container['max_cfvo']

    @max_cfvo.setter
    def max_cfvo(self, max_cfvo):
        self.container['max_cfvo'] = max_cfvo 
    @property
    def max_length(self):
        return self.container['max_length']

    @max_length.setter
    def max_length(self, max_length):
        self.container['max_length'] = max_length 
    @property
    def min_cfvo(self):
        return self.container['min_cfvo']

    @min_cfvo.setter
    def min_cfvo(self, min_cfvo):
        self.container['min_cfvo'] = min_cfvo 
    @property
    def min_length(self):
        return self.container['min_length']

    @min_length.setter
    def min_length(self, min_length):
        self.container['min_length'] = min_length 
    @property
    def negative_bar_format(self):
        return self.container['negative_bar_format']

    @negative_bar_format.setter
    def negative_bar_format(self, negative_bar_format):
        self.container['negative_bar_format'] = negative_bar_format 
    @property
    def show_value(self):
        return self.container['show_value']

    @show_value.setter
    def show_value(self, show_value):
        self.container['show_value'] = show_value 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, DataBar):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    