# coding: utf-8
"""
<copyright company="Aspose" file="ConvertTextOptionspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ConvertTextOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'data_source' : 'DataSource',
        'file_info' : 'FileInfo',
        'worksheet' : 'str',
        'range' : 'str',
        'convert_text_type' : 'str',
        'source_characters' : 'str',
        'target_characters' : 'str'
    }

    attribute_map = {
        'name' : 'Name' ,
        'data_source' : 'DataSource' ,
        'file_info' : 'FileInfo' ,
        'worksheet' : 'Worksheet' ,
        'range' : 'Range' ,
        'convert_text_type' : 'ConvertTextType' ,
        'source_characters' : 'SourceCharacters' ,
        'target_characters' : 'TargetCharacters' 
    }

    @staticmethod
    def get_swagger_types():
        return ConvertTextOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return ConvertTextOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,data_source=None ,file_info=None ,worksheet=None ,range=None ,convert_text_type=None ,source_characters=None ,target_characters=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ConvertTextOptions - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['data_source'] = None 
        self.container['file_info'] = None 
        self.container['worksheet'] = None 
        self.container['range'] = None 
        self.container['convert_text_type'] = None 
        self.container['source_characters'] = None 
        self.container['target_characters'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.data_source = data_source
        if 'data_source' in params:
            self.data_source = params["data_source"]


             
        self.file_info = file_info
        if 'file_info' in params:
            self.file_info = params["file_info"]


             
        self.worksheet = worksheet
        if 'worksheet' in params:
            self.worksheet = params["worksheet"]


             
        self.range = range
        if 'range' in params:
            self.range = params["range"]


             
        self.convert_text_type = convert_text_type
        if 'convert_text_type' in params:
            self.convert_text_type = params["convert_text_type"]


             
        self.source_characters = source_characters
        if 'source_characters' in params:
            self.source_characters = params["source_characters"]


             
        self.target_characters = target_characters
        if 'target_characters' in params:
            self.target_characters = params["target_characters"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def data_source(self):
        return self.container['data_source']

    @data_source.setter
    def data_source(self, data_source):
        self.container['data_source'] = data_source 
    @property
    def file_info(self):
        return self.container['file_info']

    @file_info.setter
    def file_info(self, file_info):
        self.container['file_info'] = file_info 
    @property
    def worksheet(self):
        return self.container['worksheet']

    @worksheet.setter
    def worksheet(self, worksheet):
        self.container['worksheet'] = worksheet 
    @property
    def range(self):
        return self.container['range']

    @range.setter
    def range(self, range):
        self.container['range'] = range 
    @property
    def convert_text_type(self):
        return self.container['convert_text_type']

    @convert_text_type.setter
    def convert_text_type(self, convert_text_type):
        self.container['convert_text_type'] = convert_text_type 
    @property
    def source_characters(self):
        return self.container['source_characters']

    @source_characters.setter
    def source_characters(self, source_characters):
        self.container['source_characters'] = source_characters 
    @property
    def target_characters(self):
        return self.container['target_characters']

    @target_characters.setter
    def target_characters(self, target_characters):
        self.container['target_characters'] = target_characters 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ConvertTextOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    