# coding: utf-8
"""
<copyright company="Aspose" file="ChartDataTablepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class ChartDataTable(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_scale_font' : 'bool',
        'background_mode' : 'str',
        'border' : 'Line',
        'font' : 'Font',
        'has_border_horizontal' : 'bool',
        'has_border_outline' : 'bool',
        'has_border_vertical' : 'bool',
        'show_legend_key' : 'bool',
        'link' : 'Link'
    }

    attribute_map = {
        'auto_scale_font' : 'AutoScaleFont' ,
        'background_mode' : 'BackgroundMode' ,
        'border' : 'Border' ,
        'font' : 'Font' ,
        'has_border_horizontal' : 'HasBorderHorizontal' ,
        'has_border_outline' : 'HasBorderOutline' ,
        'has_border_vertical' : 'HasBorderVertical' ,
        'show_legend_key' : 'ShowLegendKey' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return ChartDataTable.swagger_types

    @staticmethod
    def get_attribute_map():
        return ChartDataTable.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_scale_font=None ,background_mode=None ,border=None ,font=None ,has_border_horizontal=None ,has_border_outline=None ,has_border_vertical=None ,show_legend_key=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        ChartDataTable - a model defined in Swagger
        """
        self.container['auto_scale_font'] = None 
        self.container['background_mode'] = None 
        self.container['border'] = None 
        self.container['font'] = None 
        self.container['has_border_horizontal'] = None 
        self.container['has_border_outline'] = None 
        self.container['has_border_vertical'] = None 
        self.container['show_legend_key'] = None 
        self.container['link'] = None 
        params = locals()
        self.auto_scale_font = auto_scale_font
        if 'auto_scale_font' in params:
            self.auto_scale_font = params["auto_scale_font"]


             
        self.background_mode = background_mode
        if 'background_mode' in params:
            self.background_mode = params["background_mode"]


             
        self.border = border
        if 'border' in params:
            self.border = params["border"]


             
        self.font = font
        if 'font' in params:
            self.font = params["font"]


             
        self.has_border_horizontal = has_border_horizontal
        if 'has_border_horizontal' in params:
            self.has_border_horizontal = params["has_border_horizontal"]


             
        self.has_border_outline = has_border_outline
        if 'has_border_outline' in params:
            self.has_border_outline = params["has_border_outline"]


             
        self.has_border_vertical = has_border_vertical
        if 'has_border_vertical' in params:
            self.has_border_vertical = params["has_border_vertical"]


             
        self.show_legend_key = show_legend_key
        if 'show_legend_key' in params:
            self.show_legend_key = params["show_legend_key"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def auto_scale_font(self):
        return self.container['auto_scale_font']

    @auto_scale_font.setter
    def auto_scale_font(self, auto_scale_font):
        self.container['auto_scale_font'] = auto_scale_font 
    @property
    def background_mode(self):
        return self.container['background_mode']

    @background_mode.setter
    def background_mode(self, background_mode):
        self.container['background_mode'] = background_mode 
    @property
    def border(self):
        return self.container['border']

    @border.setter
    def border(self, border):
        self.container['border'] = border 
    @property
    def font(self):
        return self.container['font']

    @font.setter
    def font(self, font):
        self.container['font'] = font 
    @property
    def has_border_horizontal(self):
        return self.container['has_border_horizontal']

    @has_border_horizontal.setter
    def has_border_horizontal(self, has_border_horizontal):
        self.container['has_border_horizontal'] = has_border_horizontal 
    @property
    def has_border_outline(self):
        return self.container['has_border_outline']

    @has_border_outline.setter
    def has_border_outline(self, has_border_outline):
        self.container['has_border_outline'] = has_border_outline 
    @property
    def has_border_vertical(self):
        return self.container['has_border_vertical']

    @has_border_vertical.setter
    def has_border_vertical(self, has_border_vertical):
        self.container['has_border_vertical'] = has_border_vertical 
    @property
    def show_legend_key(self):
        return self.container['show_legend_key']

    @show_legend_key.setter
    def show_legend_key(self, show_legend_key):
        self.container['show_legend_key'] = show_legend_key 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ChartDataTable):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    