# coding: utf-8
"""
<copyright company="Aspose" file="CalculationOptionspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class CalculationOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'calc_stack_size' : 'int',
        'ignore_error' : 'bool',
        'precision_strategy' : 'str',
        'recursive' : 'bool',
        'custom_engine' : 'AbstractCalculationEngine',
        'calculation_monitor' : 'AbstractCalculationMonitor',
        'linked_data_sources' : 'list[Workbook]'
    }

    attribute_map = {
        'calc_stack_size' : 'CalcStackSize' ,
        'ignore_error' : 'IgnoreError' ,
        'precision_strategy' : 'PrecisionStrategy' ,
        'recursive' : 'Recursive' ,
        'custom_engine' : 'CustomEngine' ,
        'calculation_monitor' : 'CalculationMonitor' ,
        'linked_data_sources' : 'LinkedDataSources' 
    }

    @staticmethod
    def get_swagger_types():
        return CalculationOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return CalculationOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,calc_stack_size=None ,ignore_error=None ,precision_strategy=None ,recursive=None ,custom_engine=None ,calculation_monitor=None ,linked_data_sources=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        CalculationOptions - a model defined in Swagger
        """
        self.container['calc_stack_size'] = None 
        self.container['ignore_error'] = None 
        self.container['precision_strategy'] = None 
        self.container['recursive'] = None 
        self.container['custom_engine'] = None 
        self.container['calculation_monitor'] = None 
        self.container['linked_data_sources'] = None 
        params = locals()
        self.calc_stack_size = calc_stack_size
        if 'calc_stack_size' in params:
            self.calc_stack_size = params["calc_stack_size"]


             
        self.ignore_error = ignore_error
        if 'ignore_error' in params:
            self.ignore_error = params["ignore_error"]


             
        self.precision_strategy = precision_strategy
        if 'precision_strategy' in params:
            self.precision_strategy = params["precision_strategy"]


             
        self.recursive = recursive
        if 'recursive' in params:
            self.recursive = params["recursive"]


             
        self.custom_engine = custom_engine
        if 'custom_engine' in params:
            self.custom_engine = params["custom_engine"]


             
        self.calculation_monitor = calculation_monitor
        if 'calculation_monitor' in params:
            self.calculation_monitor = params["calculation_monitor"]


             
        self.linked_data_sources = linked_data_sources
        if 'linked_data_sources' in params:
            self.linked_data_sources = params["linked_data_sources"]


             

    @property
    def calc_stack_size(self):
        return self.container['calc_stack_size']

    @calc_stack_size.setter
    def calc_stack_size(self, calc_stack_size):
        self.container['calc_stack_size'] = calc_stack_size 
    @property
    def ignore_error(self):
        return self.container['ignore_error']

    @ignore_error.setter
    def ignore_error(self, ignore_error):
        self.container['ignore_error'] = ignore_error 
    @property
    def precision_strategy(self):
        return self.container['precision_strategy']

    @precision_strategy.setter
    def precision_strategy(self, precision_strategy):
        self.container['precision_strategy'] = precision_strategy 
    @property
    def recursive(self):
        return self.container['recursive']

    @recursive.setter
    def recursive(self, recursive):
        self.container['recursive'] = recursive 
    @property
    def custom_engine(self):
        return self.container['custom_engine']

    @custom_engine.setter
    def custom_engine(self, custom_engine):
        self.container['custom_engine'] = custom_engine 
    @property
    def calculation_monitor(self):
        return self.container['calculation_monitor']

    @calculation_monitor.setter
    def calculation_monitor(self, calculation_monitor):
        self.container['calculation_monitor'] = calculation_monitor 
    @property
    def linked_data_sources(self):
        return self.container['linked_data_sources']

    @linked_data_sources.setter
    def linked_data_sources(self, linked_data_sources):
        self.container['linked_data_sources'] = linked_data_sources 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CalculationOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    