# coding: utf-8
"""
<copyright company="Aspose" file="Borderpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Border(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'line_style' : 'str',
        'color' : 'Color',
        'border_type' : 'str',
        'theme_color' : 'ThemeColor',
        'argb_color' : 'int'
    }

    attribute_map = {
        'line_style' : 'LineStyle' ,
        'color' : 'Color' ,
        'border_type' : 'BorderType' ,
        'theme_color' : 'ThemeColor' ,
        'argb_color' : 'ArgbColor' 
    }

    @staticmethod
    def get_swagger_types():
        return Border.swagger_types

    @staticmethod
    def get_attribute_map():
        return Border.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,line_style=None ,color=None ,border_type=None ,theme_color=None ,argb_color=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Border - a model defined in Swagger
        """
        self.container['line_style'] = None 
        self.container['color'] = None 
        self.container['border_type'] = None 
        self.container['theme_color'] = None 
        self.container['argb_color'] = None 
        params = locals()
        self.line_style = line_style
        if 'line_style' in params:
            self.line_style = params["line_style"]


             
        self.color = color
        if 'color' in params:
            self.color = params["color"]


             
        self.border_type = border_type
        if 'border_type' in params:
            self.border_type = params["border_type"]


             
        self.theme_color = theme_color
        if 'theme_color' in params:
            self.theme_color = params["theme_color"]


             
        self.argb_color = argb_color
        if 'argb_color' in params:
            self.argb_color = params["argb_color"]


             

    @property
    def line_style(self):
        return self.container['line_style']

    @line_style.setter
    def line_style(self, line_style):
        self.container['line_style'] = line_style 
    @property
    def color(self):
        return self.container['color']

    @color.setter
    def color(self, color):
        self.container['color'] = color 
    @property
    def border_type(self):
        return self.container['border_type']

    @border_type.setter
    def border_type(self, border_type):
        self.container['border_type'] = border_type 
    @property
    def theme_color(self):
        return self.container['theme_color']

    @theme_color.setter
    def theme_color(self, theme_color):
        self.container['theme_color'] = theme_color 
    @property
    def argb_color(self):
        return self.container['argb_color']

    @argb_color.setter
    def argb_color(self, argb_color):
        self.container['argb_color'] = argb_color 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Border):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    