# coding: utf-8
"""
<copyright company="Aspose" file="Axispy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class Axis(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'area' : 'Area',
        'axis_between_categories' : 'bool',
        'axis_line' : 'Line',
        'base_unit_scale' : 'str',
        'category_type' : 'str',
        'cross_at' : 'float',
        'cross_type' : 'str',
        'display_unit' : 'str',
        'display_unit_label' : 'DisplayUnitLabel',
        'has_multi_level_labels' : 'bool',
        'is_automatic_major_unit' : 'bool',
        'is_automatic_max_value' : 'bool',
        'is_automatic_minor_unit' : 'bool',
        'is_automatic_min_value' : 'bool',
        'is_display_unit_label_shown' : 'bool',
        'is_logarithmic' : 'bool',
        'is_plot_order_reversed' : 'bool',
        'is_visible' : 'bool',
        'log_base' : 'float',
        'major_grid_lines' : 'Line',
        'major_tick_mark' : 'str',
        'major_unit' : 'float',
        'major_unit_scale' : 'str',
        'max_value' : 'float',
        'minor_grid_lines' : 'Line',
        'minor_tick_mark' : 'str',
        'minor_unit' : 'float',
        'minor_unit_scale' : 'str',
        'min_value' : 'float',
        'tick_label_position' : 'str',
        'tick_labels' : 'TickLabels',
        'tick_label_spacing' : 'int',
        'tick_mark_spacing' : 'int',
        'title' : 'Title',
        'link' : 'Link'
    }

    attribute_map = {
        'area' : 'Area' ,
        'axis_between_categories' : 'AxisBetweenCategories' ,
        'axis_line' : 'AxisLine' ,
        'base_unit_scale' : 'BaseUnitScale' ,
        'category_type' : 'CategoryType' ,
        'cross_at' : 'CrossAt' ,
        'cross_type' : 'CrossType' ,
        'display_unit' : 'DisplayUnit' ,
        'display_unit_label' : 'DisplayUnitLabel' ,
        'has_multi_level_labels' : 'HasMultiLevelLabels' ,
        'is_automatic_major_unit' : 'IsAutomaticMajorUnit' ,
        'is_automatic_max_value' : 'IsAutomaticMaxValue' ,
        'is_automatic_minor_unit' : 'IsAutomaticMinorUnit' ,
        'is_automatic_min_value' : 'IsAutomaticMinValue' ,
        'is_display_unit_label_shown' : 'IsDisplayUnitLabelShown' ,
        'is_logarithmic' : 'IsLogarithmic' ,
        'is_plot_order_reversed' : 'IsPlotOrderReversed' ,
        'is_visible' : 'IsVisible' ,
        'log_base' : 'LogBase' ,
        'major_grid_lines' : 'MajorGridLines' ,
        'major_tick_mark' : 'MajorTickMark' ,
        'major_unit' : 'MajorUnit' ,
        'major_unit_scale' : 'MajorUnitScale' ,
        'max_value' : 'MaxValue' ,
        'minor_grid_lines' : 'MinorGridLines' ,
        'minor_tick_mark' : 'MinorTickMark' ,
        'minor_unit' : 'MinorUnit' ,
        'minor_unit_scale' : 'MinorUnitScale' ,
        'min_value' : 'MinValue' ,
        'tick_label_position' : 'TickLabelPosition' ,
        'tick_labels' : 'TickLabels' ,
        'tick_label_spacing' : 'TickLabelSpacing' ,
        'tick_mark_spacing' : 'TickMarkSpacing' ,
        'title' : 'Title' ,
        'link' : 'link' 
    }

    @staticmethod
    def get_swagger_types():
        return Axis.swagger_types

    @staticmethod
    def get_attribute_map():
        return Axis.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,area=None ,axis_between_categories=None ,axis_line=None ,base_unit_scale=None ,category_type=None ,cross_at=None ,cross_type=None ,display_unit=None ,display_unit_label=None ,has_multi_level_labels=None ,is_automatic_major_unit=None ,is_automatic_max_value=None ,is_automatic_minor_unit=None ,is_automatic_min_value=None ,is_display_unit_label_shown=None ,is_logarithmic=None ,is_plot_order_reversed=None ,is_visible=None ,log_base=None ,major_grid_lines=None ,major_tick_mark=None ,major_unit=None ,major_unit_scale=None ,max_value=None ,minor_grid_lines=None ,minor_tick_mark=None ,minor_unit=None ,minor_unit_scale=None ,min_value=None ,tick_label_position=None ,tick_labels=None ,tick_label_spacing=None ,tick_mark_spacing=None ,title=None ,link=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        Axis - a model defined in Swagger
        """
        self.container['area'] = None 
        self.container['axis_between_categories'] = None 
        self.container['axis_line'] = None 
        self.container['base_unit_scale'] = None 
        self.container['category_type'] = None 
        self.container['cross_at'] = None 
        self.container['cross_type'] = None 
        self.container['display_unit'] = None 
        self.container['display_unit_label'] = None 
        self.container['has_multi_level_labels'] = None 
        self.container['is_automatic_major_unit'] = None 
        self.container['is_automatic_max_value'] = None 
        self.container['is_automatic_minor_unit'] = None 
        self.container['is_automatic_min_value'] = None 
        self.container['is_display_unit_label_shown'] = None 
        self.container['is_logarithmic'] = None 
        self.container['is_plot_order_reversed'] = None 
        self.container['is_visible'] = None 
        self.container['log_base'] = None 
        self.container['major_grid_lines'] = None 
        self.container['major_tick_mark'] = None 
        self.container['major_unit'] = None 
        self.container['major_unit_scale'] = None 
        self.container['max_value'] = None 
        self.container['minor_grid_lines'] = None 
        self.container['minor_tick_mark'] = None 
        self.container['minor_unit'] = None 
        self.container['minor_unit_scale'] = None 
        self.container['min_value'] = None 
        self.container['tick_label_position'] = None 
        self.container['tick_labels'] = None 
        self.container['tick_label_spacing'] = None 
        self.container['tick_mark_spacing'] = None 
        self.container['title'] = None 
        self.container['link'] = None 
        params = locals()
        self.area = area
        if 'area' in params:
            self.area = params["area"]


             
        self.axis_between_categories = axis_between_categories
        if 'axis_between_categories' in params:
            self.axis_between_categories = params["axis_between_categories"]


             
        self.axis_line = axis_line
        if 'axis_line' in params:
            self.axis_line = params["axis_line"]


             
        self.base_unit_scale = base_unit_scale
        if 'base_unit_scale' in params:
            self.base_unit_scale = params["base_unit_scale"]


             
        self.category_type = category_type
        if 'category_type' in params:
            self.category_type = params["category_type"]


             
        self.cross_at = cross_at
        if 'cross_at' in params:
            self.cross_at = params["cross_at"]


             
        self.cross_type = cross_type
        if 'cross_type' in params:
            self.cross_type = params["cross_type"]


             
        self.display_unit = display_unit
        if 'display_unit' in params:
            self.display_unit = params["display_unit"]


             
        self.display_unit_label = display_unit_label
        if 'display_unit_label' in params:
            self.display_unit_label = params["display_unit_label"]


             
        self.has_multi_level_labels = has_multi_level_labels
        if 'has_multi_level_labels' in params:
            self.has_multi_level_labels = params["has_multi_level_labels"]


             
        self.is_automatic_major_unit = is_automatic_major_unit
        if 'is_automatic_major_unit' in params:
            self.is_automatic_major_unit = params["is_automatic_major_unit"]


             
        self.is_automatic_max_value = is_automatic_max_value
        if 'is_automatic_max_value' in params:
            self.is_automatic_max_value = params["is_automatic_max_value"]


             
        self.is_automatic_minor_unit = is_automatic_minor_unit
        if 'is_automatic_minor_unit' in params:
            self.is_automatic_minor_unit = params["is_automatic_minor_unit"]


             
        self.is_automatic_min_value = is_automatic_min_value
        if 'is_automatic_min_value' in params:
            self.is_automatic_min_value = params["is_automatic_min_value"]


             
        self.is_display_unit_label_shown = is_display_unit_label_shown
        if 'is_display_unit_label_shown' in params:
            self.is_display_unit_label_shown = params["is_display_unit_label_shown"]


             
        self.is_logarithmic = is_logarithmic
        if 'is_logarithmic' in params:
            self.is_logarithmic = params["is_logarithmic"]


             
        self.is_plot_order_reversed = is_plot_order_reversed
        if 'is_plot_order_reversed' in params:
            self.is_plot_order_reversed = params["is_plot_order_reversed"]


             
        self.is_visible = is_visible
        if 'is_visible' in params:
            self.is_visible = params["is_visible"]


             
        self.log_base = log_base
        if 'log_base' in params:
            self.log_base = params["log_base"]


             
        self.major_grid_lines = major_grid_lines
        if 'major_grid_lines' in params:
            self.major_grid_lines = params["major_grid_lines"]


             
        self.major_tick_mark = major_tick_mark
        if 'major_tick_mark' in params:
            self.major_tick_mark = params["major_tick_mark"]


             
        self.major_unit = major_unit
        if 'major_unit' in params:
            self.major_unit = params["major_unit"]


             
        self.major_unit_scale = major_unit_scale
        if 'major_unit_scale' in params:
            self.major_unit_scale = params["major_unit_scale"]


             
        self.max_value = max_value
        if 'max_value' in params:
            self.max_value = params["max_value"]


             
        self.minor_grid_lines = minor_grid_lines
        if 'minor_grid_lines' in params:
            self.minor_grid_lines = params["minor_grid_lines"]


             
        self.minor_tick_mark = minor_tick_mark
        if 'minor_tick_mark' in params:
            self.minor_tick_mark = params["minor_tick_mark"]


             
        self.minor_unit = minor_unit
        if 'minor_unit' in params:
            self.minor_unit = params["minor_unit"]


             
        self.minor_unit_scale = minor_unit_scale
        if 'minor_unit_scale' in params:
            self.minor_unit_scale = params["minor_unit_scale"]


             
        self.min_value = min_value
        if 'min_value' in params:
            self.min_value = params["min_value"]


             
        self.tick_label_position = tick_label_position
        if 'tick_label_position' in params:
            self.tick_label_position = params["tick_label_position"]


             
        self.tick_labels = tick_labels
        if 'tick_labels' in params:
            self.tick_labels = params["tick_labels"]


             
        self.tick_label_spacing = tick_label_spacing
        if 'tick_label_spacing' in params:
            self.tick_label_spacing = params["tick_label_spacing"]


             
        self.tick_mark_spacing = tick_mark_spacing
        if 'tick_mark_spacing' in params:
            self.tick_mark_spacing = params["tick_mark_spacing"]


             
        self.title = title
        if 'title' in params:
            self.title = params["title"]


             
        self.link = link
        if 'link' in params:
            self.link = params["link"]


             

    @property
    def area(self):
        return self.container['area']

    @area.setter
    def area(self, area):
        self.container['area'] = area 
    @property
    def axis_between_categories(self):
        return self.container['axis_between_categories']

    @axis_between_categories.setter
    def axis_between_categories(self, axis_between_categories):
        self.container['axis_between_categories'] = axis_between_categories 
    @property
    def axis_line(self):
        return self.container['axis_line']

    @axis_line.setter
    def axis_line(self, axis_line):
        self.container['axis_line'] = axis_line 
    @property
    def base_unit_scale(self):
        return self.container['base_unit_scale']

    @base_unit_scale.setter
    def base_unit_scale(self, base_unit_scale):
        self.container['base_unit_scale'] = base_unit_scale 
    @property
    def category_type(self):
        return self.container['category_type']

    @category_type.setter
    def category_type(self, category_type):
        self.container['category_type'] = category_type 
    @property
    def cross_at(self):
        return self.container['cross_at']

    @cross_at.setter
    def cross_at(self, cross_at):
        self.container['cross_at'] = cross_at 
    @property
    def cross_type(self):
        return self.container['cross_type']

    @cross_type.setter
    def cross_type(self, cross_type):
        self.container['cross_type'] = cross_type 
    @property
    def display_unit(self):
        return self.container['display_unit']

    @display_unit.setter
    def display_unit(self, display_unit):
        self.container['display_unit'] = display_unit 
    @property
    def display_unit_label(self):
        return self.container['display_unit_label']

    @display_unit_label.setter
    def display_unit_label(self, display_unit_label):
        self.container['display_unit_label'] = display_unit_label 
    @property
    def has_multi_level_labels(self):
        return self.container['has_multi_level_labels']

    @has_multi_level_labels.setter
    def has_multi_level_labels(self, has_multi_level_labels):
        self.container['has_multi_level_labels'] = has_multi_level_labels 
    @property
    def is_automatic_major_unit(self):
        return self.container['is_automatic_major_unit']

    @is_automatic_major_unit.setter
    def is_automatic_major_unit(self, is_automatic_major_unit):
        self.container['is_automatic_major_unit'] = is_automatic_major_unit 
    @property
    def is_automatic_max_value(self):
        return self.container['is_automatic_max_value']

    @is_automatic_max_value.setter
    def is_automatic_max_value(self, is_automatic_max_value):
        self.container['is_automatic_max_value'] = is_automatic_max_value 
    @property
    def is_automatic_minor_unit(self):
        return self.container['is_automatic_minor_unit']

    @is_automatic_minor_unit.setter
    def is_automatic_minor_unit(self, is_automatic_minor_unit):
        self.container['is_automatic_minor_unit'] = is_automatic_minor_unit 
    @property
    def is_automatic_min_value(self):
        return self.container['is_automatic_min_value']

    @is_automatic_min_value.setter
    def is_automatic_min_value(self, is_automatic_min_value):
        self.container['is_automatic_min_value'] = is_automatic_min_value 
    @property
    def is_display_unit_label_shown(self):
        return self.container['is_display_unit_label_shown']

    @is_display_unit_label_shown.setter
    def is_display_unit_label_shown(self, is_display_unit_label_shown):
        self.container['is_display_unit_label_shown'] = is_display_unit_label_shown 
    @property
    def is_logarithmic(self):
        return self.container['is_logarithmic']

    @is_logarithmic.setter
    def is_logarithmic(self, is_logarithmic):
        self.container['is_logarithmic'] = is_logarithmic 
    @property
    def is_plot_order_reversed(self):
        return self.container['is_plot_order_reversed']

    @is_plot_order_reversed.setter
    def is_plot_order_reversed(self, is_plot_order_reversed):
        self.container['is_plot_order_reversed'] = is_plot_order_reversed 
    @property
    def is_visible(self):
        return self.container['is_visible']

    @is_visible.setter
    def is_visible(self, is_visible):
        self.container['is_visible'] = is_visible 
    @property
    def log_base(self):
        return self.container['log_base']

    @log_base.setter
    def log_base(self, log_base):
        self.container['log_base'] = log_base 
    @property
    def major_grid_lines(self):
        return self.container['major_grid_lines']

    @major_grid_lines.setter
    def major_grid_lines(self, major_grid_lines):
        self.container['major_grid_lines'] = major_grid_lines 
    @property
    def major_tick_mark(self):
        return self.container['major_tick_mark']

    @major_tick_mark.setter
    def major_tick_mark(self, major_tick_mark):
        self.container['major_tick_mark'] = major_tick_mark 
    @property
    def major_unit(self):
        return self.container['major_unit']

    @major_unit.setter
    def major_unit(self, major_unit):
        self.container['major_unit'] = major_unit 
    @property
    def major_unit_scale(self):
        return self.container['major_unit_scale']

    @major_unit_scale.setter
    def major_unit_scale(self, major_unit_scale):
        self.container['major_unit_scale'] = major_unit_scale 
    @property
    def max_value(self):
        return self.container['max_value']

    @max_value.setter
    def max_value(self, max_value):
        self.container['max_value'] = max_value 
    @property
    def minor_grid_lines(self):
        return self.container['minor_grid_lines']

    @minor_grid_lines.setter
    def minor_grid_lines(self, minor_grid_lines):
        self.container['minor_grid_lines'] = minor_grid_lines 
    @property
    def minor_tick_mark(self):
        return self.container['minor_tick_mark']

    @minor_tick_mark.setter
    def minor_tick_mark(self, minor_tick_mark):
        self.container['minor_tick_mark'] = minor_tick_mark 
    @property
    def minor_unit(self):
        return self.container['minor_unit']

    @minor_unit.setter
    def minor_unit(self, minor_unit):
        self.container['minor_unit'] = minor_unit 
    @property
    def minor_unit_scale(self):
        return self.container['minor_unit_scale']

    @minor_unit_scale.setter
    def minor_unit_scale(self, minor_unit_scale):
        self.container['minor_unit_scale'] = minor_unit_scale 
    @property
    def min_value(self):
        return self.container['min_value']

    @min_value.setter
    def min_value(self, min_value):
        self.container['min_value'] = min_value 
    @property
    def tick_label_position(self):
        return self.container['tick_label_position']

    @tick_label_position.setter
    def tick_label_position(self, tick_label_position):
        self.container['tick_label_position'] = tick_label_position 
    @property
    def tick_labels(self):
        return self.container['tick_labels']

    @tick_labels.setter
    def tick_labels(self, tick_labels):
        self.container['tick_labels'] = tick_labels 
    @property
    def tick_label_spacing(self):
        return self.container['tick_label_spacing']

    @tick_label_spacing.setter
    def tick_label_spacing(self, tick_label_spacing):
        self.container['tick_label_spacing'] = tick_label_spacing 
    @property
    def tick_mark_spacing(self):
        return self.container['tick_mark_spacing']

    @tick_mark_spacing.setter
    def tick_mark_spacing(self, tick_mark_spacing):
        self.container['tick_mark_spacing'] = tick_mark_spacing 
    @property
    def title(self):
        return self.container['title']

    @title.setter
    def title(self, title):
        self.container['title'] = title 
    @property
    def link(self):
        return self.container['link']

    @link.setter
    def link(self, link):
        self.container['link'] = link 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, Axis):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    