# coding: utf-8
"""
<copyright company="Aspose" file="AutoFitterOptionspy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AutoFitterOptions(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'auto_fit_merged_cells_type' : 'str',
        'ignore_hidden' : 'bool',
        'only_auto' : 'bool',
        'default_edit_language' : 'str',
        'max_row_height' : 'float',
        'auto_fit_wrapped_text_type' : 'str',
        'format_strategy' : 'str',
        'for_rendering' : 'bool'
    }

    attribute_map = {
        'auto_fit_merged_cells_type' : 'AutoFitMergedCellsType' ,
        'ignore_hidden' : 'IgnoreHidden' ,
        'only_auto' : 'OnlyAuto' ,
        'default_edit_language' : 'DefaultEditLanguage' ,
        'max_row_height' : 'MaxRowHeight' ,
        'auto_fit_wrapped_text_type' : 'AutoFitWrappedTextType' ,
        'format_strategy' : 'FormatStrategy' ,
        'for_rendering' : 'ForRendering' 
    }

    @staticmethod
    def get_swagger_types():
        return AutoFitterOptions.swagger_types

    @staticmethod
    def get_attribute_map():
        return AutoFitterOptions.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,auto_fit_merged_cells_type=None ,ignore_hidden=None ,only_auto=None ,default_edit_language=None ,max_row_height=None ,auto_fit_wrapped_text_type=None ,format_strategy=None ,for_rendering=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AutoFitterOptions - a model defined in Swagger
        """
        self.container['auto_fit_merged_cells_type'] = None 
        self.container['ignore_hidden'] = None 
        self.container['only_auto'] = None 
        self.container['default_edit_language'] = None 
        self.container['max_row_height'] = None 
        self.container['auto_fit_wrapped_text_type'] = None 
        self.container['format_strategy'] = None 
        self.container['for_rendering'] = None 
        params = locals()
        self.auto_fit_merged_cells_type = auto_fit_merged_cells_type
        if 'auto_fit_merged_cells_type' in params:
            self.auto_fit_merged_cells_type = params["auto_fit_merged_cells_type"]


             
        self.ignore_hidden = ignore_hidden
        if 'ignore_hidden' in params:
            self.ignore_hidden = params["ignore_hidden"]


             
        self.only_auto = only_auto
        if 'only_auto' in params:
            self.only_auto = params["only_auto"]


             
        self.default_edit_language = default_edit_language
        if 'default_edit_language' in params:
            self.default_edit_language = params["default_edit_language"]


             
        self.max_row_height = max_row_height
        if 'max_row_height' in params:
            self.max_row_height = params["max_row_height"]


             
        self.auto_fit_wrapped_text_type = auto_fit_wrapped_text_type
        if 'auto_fit_wrapped_text_type' in params:
            self.auto_fit_wrapped_text_type = params["auto_fit_wrapped_text_type"]


             
        self.format_strategy = format_strategy
        if 'format_strategy' in params:
            self.format_strategy = params["format_strategy"]


             
        self.for_rendering = for_rendering
        if 'for_rendering' in params:
            self.for_rendering = params["for_rendering"]


             

    @property
    def auto_fit_merged_cells_type(self):
        return self.container['auto_fit_merged_cells_type']

    @auto_fit_merged_cells_type.setter
    def auto_fit_merged_cells_type(self, auto_fit_merged_cells_type):
        self.container['auto_fit_merged_cells_type'] = auto_fit_merged_cells_type 
    @property
    def ignore_hidden(self):
        return self.container['ignore_hidden']

    @ignore_hidden.setter
    def ignore_hidden(self, ignore_hidden):
        self.container['ignore_hidden'] = ignore_hidden 
    @property
    def only_auto(self):
        return self.container['only_auto']

    @only_auto.setter
    def only_auto(self, only_auto):
        self.container['only_auto'] = only_auto 
    @property
    def default_edit_language(self):
        return self.container['default_edit_language']

    @default_edit_language.setter
    def default_edit_language(self, default_edit_language):
        self.container['default_edit_language'] = default_edit_language 
    @property
    def max_row_height(self):
        return self.container['max_row_height']

    @max_row_height.setter
    def max_row_height(self, max_row_height):
        self.container['max_row_height'] = max_row_height 
    @property
    def auto_fit_wrapped_text_type(self):
        return self.container['auto_fit_wrapped_text_type']

    @auto_fit_wrapped_text_type.setter
    def auto_fit_wrapped_text_type(self, auto_fit_wrapped_text_type):
        self.container['auto_fit_wrapped_text_type'] = auto_fit_wrapped_text_type 
    @property
    def format_strategy(self):
        return self.container['format_strategy']

    @format_strategy.setter
    def format_strategy(self, format_strategy):
        self.container['format_strategy'] = format_strategy 
    @property
    def for_rendering(self):
        return self.container['for_rendering']

    @for_rendering.setter
    def for_rendering(self, for_rendering):
        self.container['for_rendering'] = for_rendering 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AutoFitterOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    