# coding: utf-8
"""
<copyright company="Aspose" file="AnalyzedTableDescriptionpy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AnalyzedTableDescription(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'name' : 'str',
        'sheet_name' : 'str',
        'columns' : 'list[AnalyzedColumnDescription]',
        'date_columns' : 'list[int]',
        'number_columns' : 'list[int]',
        'text_columns' : 'list[int]',
        'exception_columns' : 'list[int]',
        'has_table_header_row' : 'bool',
        'has_table_total_row' : 'bool',
        'start_data_column_index' : 'int',
        'end_data_column_index' : 'int',
        'start_data_row_index' : 'int',
        'end_data_row_index' : 'int',
        'thumbnail' : 'str',
        'discover_charts' : 'list[DiscoverChart]',
        'discover_pivot_tables' : 'list[DiscoverPivotTable]'
    }

    attribute_map = {
        'name' : 'Name' ,
        'sheet_name' : 'SheetName' ,
        'columns' : 'Columns' ,
        'date_columns' : 'DateColumns' ,
        'number_columns' : 'NumberColumns' ,
        'text_columns' : 'TextColumns' ,
        'exception_columns' : 'ExceptionColumns' ,
        'has_table_header_row' : 'HasTableHeaderRow' ,
        'has_table_total_row' : 'HasTableTotalRow' ,
        'start_data_column_index' : 'StartDataColumnIndex' ,
        'end_data_column_index' : 'EndDataColumnIndex' ,
        'start_data_row_index' : 'StartDataRowIndex' ,
        'end_data_row_index' : 'EndDataRowIndex' ,
        'thumbnail' : 'Thumbnail' ,
        'discover_charts' : 'DiscoverCharts' ,
        'discover_pivot_tables' : 'DiscoverPivotTables' 
    }

    @staticmethod
    def get_swagger_types():
        return AnalyzedTableDescription.swagger_types

    @staticmethod
    def get_attribute_map():
        return AnalyzedTableDescription.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,name=None ,sheet_name=None ,columns=None ,date_columns=None ,number_columns=None ,text_columns=None ,exception_columns=None ,has_table_header_row=None ,has_table_total_row=None ,start_data_column_index=None ,end_data_column_index=None ,start_data_row_index=None ,end_data_row_index=None ,thumbnail=None ,discover_charts=None ,discover_pivot_tables=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AnalyzedTableDescription - a model defined in Swagger
        """
        self.container['name'] = None 
        self.container['sheet_name'] = None 
        self.container['columns'] = None 
        self.container['date_columns'] = None 
        self.container['number_columns'] = None 
        self.container['text_columns'] = None 
        self.container['exception_columns'] = None 
        self.container['has_table_header_row'] = None 
        self.container['has_table_total_row'] = None 
        self.container['start_data_column_index'] = None 
        self.container['end_data_column_index'] = None 
        self.container['start_data_row_index'] = None 
        self.container['end_data_row_index'] = None 
        self.container['thumbnail'] = None 
        self.container['discover_charts'] = None 
        self.container['discover_pivot_tables'] = None 
        params = locals()
        self.name = name
        if 'name' in params:
            self.name = params["name"]


             
        self.sheet_name = sheet_name
        if 'sheet_name' in params:
            self.sheet_name = params["sheet_name"]


             
        self.columns = columns
        if 'columns' in params:
            self.columns = params["columns"]


             
        self.date_columns = date_columns
        if 'date_columns' in params:
            self.date_columns = params["date_columns"]


             
        self.number_columns = number_columns
        if 'number_columns' in params:
            self.number_columns = params["number_columns"]


             
        self.text_columns = text_columns
        if 'text_columns' in params:
            self.text_columns = params["text_columns"]


             
        self.exception_columns = exception_columns
        if 'exception_columns' in params:
            self.exception_columns = params["exception_columns"]


             
        self.has_table_header_row = has_table_header_row
        if 'has_table_header_row' in params:
            self.has_table_header_row = params["has_table_header_row"]


             
        self.has_table_total_row = has_table_total_row
        if 'has_table_total_row' in params:
            self.has_table_total_row = params["has_table_total_row"]


             
        self.start_data_column_index = start_data_column_index
        if 'start_data_column_index' in params:
            self.start_data_column_index = params["start_data_column_index"]


             
        self.end_data_column_index = end_data_column_index
        if 'end_data_column_index' in params:
            self.end_data_column_index = params["end_data_column_index"]


             
        self.start_data_row_index = start_data_row_index
        if 'start_data_row_index' in params:
            self.start_data_row_index = params["start_data_row_index"]


             
        self.end_data_row_index = end_data_row_index
        if 'end_data_row_index' in params:
            self.end_data_row_index = params["end_data_row_index"]


             
        self.thumbnail = thumbnail
        if 'thumbnail' in params:
            self.thumbnail = params["thumbnail"]


             
        self.discover_charts = discover_charts
        if 'discover_charts' in params:
            self.discover_charts = params["discover_charts"]


             
        self.discover_pivot_tables = discover_pivot_tables
        if 'discover_pivot_tables' in params:
            self.discover_pivot_tables = params["discover_pivot_tables"]


             

    @property
    def name(self):
        return self.container['name']

    @name.setter
    def name(self, name):
        self.container['name'] = name 
    @property
    def sheet_name(self):
        return self.container['sheet_name']

    @sheet_name.setter
    def sheet_name(self, sheet_name):
        self.container['sheet_name'] = sheet_name 
    @property
    def columns(self):
        return self.container['columns']

    @columns.setter
    def columns(self, columns):
        self.container['columns'] = columns 
    @property
    def date_columns(self):
        return self.container['date_columns']

    @date_columns.setter
    def date_columns(self, date_columns):
        self.container['date_columns'] = date_columns 
    @property
    def number_columns(self):
        return self.container['number_columns']

    @number_columns.setter
    def number_columns(self, number_columns):
        self.container['number_columns'] = number_columns 
    @property
    def text_columns(self):
        return self.container['text_columns']

    @text_columns.setter
    def text_columns(self, text_columns):
        self.container['text_columns'] = text_columns 
    @property
    def exception_columns(self):
        return self.container['exception_columns']

    @exception_columns.setter
    def exception_columns(self, exception_columns):
        self.container['exception_columns'] = exception_columns 
    @property
    def has_table_header_row(self):
        return self.container['has_table_header_row']

    @has_table_header_row.setter
    def has_table_header_row(self, has_table_header_row):
        self.container['has_table_header_row'] = has_table_header_row 
    @property
    def has_table_total_row(self):
        return self.container['has_table_total_row']

    @has_table_total_row.setter
    def has_table_total_row(self, has_table_total_row):
        self.container['has_table_total_row'] = has_table_total_row 
    @property
    def start_data_column_index(self):
        return self.container['start_data_column_index']

    @start_data_column_index.setter
    def start_data_column_index(self, start_data_column_index):
        self.container['start_data_column_index'] = start_data_column_index 
    @property
    def end_data_column_index(self):
        return self.container['end_data_column_index']

    @end_data_column_index.setter
    def end_data_column_index(self, end_data_column_index):
        self.container['end_data_column_index'] = end_data_column_index 
    @property
    def start_data_row_index(self):
        return self.container['start_data_row_index']

    @start_data_row_index.setter
    def start_data_row_index(self, start_data_row_index):
        self.container['start_data_row_index'] = start_data_row_index 
    @property
    def end_data_row_index(self):
        return self.container['end_data_row_index']

    @end_data_row_index.setter
    def end_data_row_index(self, end_data_row_index):
        self.container['end_data_row_index'] = end_data_row_index 
    @property
    def thumbnail(self):
        return self.container['thumbnail']

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        self.container['thumbnail'] = thumbnail 
    @property
    def discover_charts(self):
        return self.container['discover_charts']

    @discover_charts.setter
    def discover_charts(self, discover_charts):
        self.container['discover_charts'] = discover_charts 
    @property
    def discover_pivot_tables(self):
        return self.container['discover_pivot_tables']

    @discover_pivot_tables.setter
    def discover_pivot_tables(self, discover_pivot_tables):
        self.container['discover_pivot_tables'] = discover_pivot_tables 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AnalyzedTableDescription):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    