# coding: utf-8
"""
<copyright company="Aspose" file="AbstractCalculationEnginepy.cs">
  Copyright (c) 2024 Aspose.Cells Cloud
</copyright>
<summary>
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all
 copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 SOFTWARE.
</summary>
"""

from pprint import pformat
from six import iteritems
import re

class AbstractCalculationEngine(object):

    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    swagger_types = {
        'is_param_literal_required' : 'bool',
        'is_param_array_mode_required' : 'bool',
        'process_built_in_functions' : 'bool'
    }

    attribute_map = {
        'is_param_literal_required' : 'IsParamLiteralRequired' ,
        'is_param_array_mode_required' : 'IsParamArrayModeRequired' ,
        'process_built_in_functions' : 'ProcessBuiltInFunctions' 
    }

    @staticmethod
    def get_swagger_types():
        return AbstractCalculationEngine.swagger_types

    @staticmethod
    def get_attribute_map():
        return AbstractCalculationEngine.attribute_map

    def get_from_container(self, attr):
        if attr in self.container:
            return self.container[attr]
        return None

    def __init__(self,is_param_literal_required=None ,is_param_array_mode_required=None ,process_built_in_functions=None   ,**kw):
        """
        Associative dict for storing property values
        """
        self.container = {}

        """
        AbstractCalculationEngine - a model defined in Swagger
        """
        self.container['is_param_literal_required'] = None 
        self.container['is_param_array_mode_required'] = None 
        self.container['process_built_in_functions'] = None 
        params = locals()
        self.is_param_literal_required = is_param_literal_required
        if 'is_param_literal_required' in params:
            self.is_param_literal_required = params["is_param_literal_required"]


             
        self.is_param_array_mode_required = is_param_array_mode_required
        if 'is_param_array_mode_required' in params:
            self.is_param_array_mode_required = params["is_param_array_mode_required"]


             
        self.process_built_in_functions = process_built_in_functions
        if 'process_built_in_functions' in params:
            self.process_built_in_functions = params["process_built_in_functions"]


             

    @property
    def is_param_literal_required(self):
        return self.container['is_param_literal_required']

    @is_param_literal_required.setter
    def is_param_literal_required(self, is_param_literal_required):
        self.container['is_param_literal_required'] = is_param_literal_required 
    @property
    def is_param_array_mode_required(self):
        return self.container['is_param_array_mode_required']

    @is_param_array_mode_required.setter
    def is_param_array_mode_required(self, is_param_array_mode_required):
        self.container['is_param_array_mode_required'] = is_param_array_mode_required 
    @property
    def process_built_in_functions(self):
        return self.container['process_built_in_functions']

    @process_built_in_functions.setter
    def process_built_in_functions(self, process_built_in_functions):
        self.container['process_built_in_functions'] = process_built_in_functions 

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.get_swagger_types()):
            value = self.get_from_container(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, AbstractCalculationEngine):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other    