# Introduction to Web Frameworks

## Road Map
* Discuss what frameworks are and why they help us write applications
* Learn the distinction between frontend, backend and CSS frameworks
* Learn which frameworks are popular for now and why
* Know how to make decisions on which frameworks to use for projects

### What type of app would you build?
If you are unsure, [here](https://github.com/tastejs/awesome-app-ideas) and [here](https://devcereal.com/21-web-app-ideas-beginner-projects/) have some great ideas! Also, spend some time thinking about what would make your app most successful. Discuss your ideas with the people at your table.

### Web Application Similarities
Look at Facebook, Twitter, LinkedIn, and GitHub and list some of the similarities you see with the people near you.

## What are Frameworks
If we look at a couple different web applications we can see that there area  lot of duplicated features. All of the ones we looked at above have user authentication, views that render, they connect to databases, they have profiles you can look at, they all have stylized feeds of information etc. If I wanted to, I could write all of that logic myself every time I want to build a new application; however, there are also a lot of tools available which can do that for us instead. In addition, a lot of the time when we build applications we want to format our code in certain ways that help us be efficient and help other developers more easily understand our code. Web frameworks help us achieve structure for our applications, and they give us additional features we can add to our applications without too much extra work. Frameworks give us a place to start with our applications so that we can focus on features for our applications rather than configuration details.

```
Most websites share a very similar (not to say identical) structure. The aim of frameworks is to provide a common structure so that developers don’t have to redo it from scratch and can reuse the code provided. In this way, frameworks allow us to cut out much of the work and save a lot of time.

To summarize: there’s no need to reinvent the wheel.
``` 
from [Awwwards](https://www.awwwards.com/what-are-frameworks-22-best-responsive-css-frameworks-for-web-design.html).

## Backend vs Frontend
* The **frontend** of a web application is the part you see and interact with. It consists of the web design and the interaction of the site. In terms of programming languages, this is almost always comprised of the CSS, HTML, and JavaScript of the page.

* The **backend** consists of the server, the database, and the code that interacts with them. This also consists of the code that gives dynamic data to the frontend of the site. This can be handled in most programming langues. The ones we will discuss primarily today are Python, Ruby, and Node JavaScript but there are countless others.

## User Interface Frameworks
User interface frameworks help create stylized and professional looking web applications. Most include some sort of grid system so that you can have elements aligned well, they have color schemes so that is handled for you, and they stylize your HTML components so that they look clean and professional.

Some of these include:
* [Bootstrap](http://getbootstrap.com/)
    * Very well known and built by Twitter
    * Easy to learn and looks professional
    * Can be easy to spot "Bootstrap Sites"
    * Can be difficult to customize components
* [Materialize](http://materializecss.com/)
    * Clean looking
    * A bit more "fun" than Bootstrap
    * Lots of styling and color options
    * Follows Google's Material style guide
* [Foundation](http://foundation.zurb.com/)
    * Lots of examples
    * Professional looking
* [Semantic UI](https://semantic-ui.com/)
    * Lots built in
    * Built in themes so its customizable
* [Grommet](https://grommet.github.io/)
    * Has a huge focus on accessibility
    * Looks really clean
    * Not as used as some of the others
    * Made for React JS (another framework we will look at later)


### Choosing a UI Framework
Choosing a UI framework mostly comes down to personal preference in appearance and the goals of the site. The different styles may appeal to different industries more or may convey a different message.

Spend a few minutes discussing the appearances of different ones and choose which would be best for your sample app.


## Frontend Frameworks
* [Vue](https://vuejs.org/)
    * Easy to learn
    * Very fast
    * All tools associated with it are packaged well
    * Takes parts from Angular and React and optimizes them
    * less widely adopted than some others
    * Flexible -- you can use it in multiple ways
* [AngularJS](https://angularjs.org/)
    * Built by Google
    * Well supported
    * Huge number of features
    * Improves application scalability
    * Difficult to debug
    * Large learning curve
* [Angular 2+](https://angular.io/)
    * Built by Google
    * Well supported
    * Encourages reusability
    * Improves application scalability
    * Large learning curve
* [React](https://facebook.github.io/react/)
    * Built by Facebook
    * Bundles frontend code into components
    * Organizes code and data to make code more reusable
    * Large learning curve
    * Has some controversy with its intellectual property clauses
* [Ember](https://www.emberjs.com/)
    * Gives a large amount of functionality out of the box
    * Opinionated (you have to use its formatting)
    * Steep learning curve

### Choosing a Frontend Framework
Go through some of [these](https://github.com/gothinkster/realworld) and look at the code. Also research the pros and cons of each. Think of which would be best to learn or integrate into your app idea.

## Backend Frameworks
* [Spring MVC](https://spring.io/)
    * Java (more difficult language to learn)
    * Very fast
    * Less opinionated
* [Django](https://www.djangoproject.com/)
    * Python (easier language to learn)
    * Happy medium between being very opinionated and less structured\
    * Gives you a lot of functionality out of the box (like user authentication, database connections, and view rendering)
    * Can be difficult to integrate a fancy frontend.
    * Python's data handling is amazing
* [Flask](http://flask.pocoo.org/)
    * Python (easier language to learn)
    * Less opinionated and more customizable than Django
    * Gives you less out of the box (you have to build more)
* [Ruby on Rails](http://rubyonrails.org/)
    * Ruby (easier language to learn)
    * Very opinionated
    * Has great tools like scaffolding so you can build things fast
    * Gives you a lot of functionality out of the box (like user authentication, database connections, and view rendering)
    * The asset pipeline helps with frontend development
    * Ruby takes longer to run programs than some other programming languages
* [Meteor](https://www.meteor.com/)
    * JavaScript (easier language to learn)
    * Gives you a lot of functionality out of the box (like user authentication, database connections, and view rendering)
    * Integrates very well with modern frontends
* [Express](https://expressjs.com/)
    * JavaScript (easier language to learn)
    * Very customizable
    * Very lightweight
    * Less builtin features
    * Node is very fast

### Choosing a Backend Framework
Go through some of [these](https://github.com/gothinkster/realworld) and look at the code. Also research the pros and cons of each. Think of which would be best to learn or integrate into your app idea.

## More Resources!
* [Django Girls Tutorial](https://tutorial.djangogirls.org/en/)
* [Code Academy](https://www.codecademy.com/)
* [TodoMVC](http://todomvc.com/)
* [CodeNewbie Podcast](https://www.codenewbie.org/podcast)
* [Women Who Code DC](https://www.meetup.com/Women-Who-Code-DC/)
* [How fast are different programming languages?](http://benchmarksgame.alioth.debian.org/)


## Stay in touch!
* [aspittel.github.io](aspittel.github.io)
* [@aspittel](twitter.com/aspittel) on Twitter
* [aspittel](github.com/aspittel) on GitHub
* [Ali Spittel](https://www.linkedin.com/in/ali-spittel-768a98119) on LinkedIn

