# Response object

Axios cache interceptor returns a slightly changed than the original axios response.
Containing information about the cache and other needed properties.

## id

- Type: `string`

The [Request ID](../guide/request-id.md) used in this request.

It may have been generated by the [Key Generator](../guide/request-id.md#custom-generator)
or a custom one provided by [`config.id`](./request-specifics.md#id)

```ts
const response = await axios.get('url', { id: 'my-overridden-id' });

// This request used 'my-overridden-id' and
// not the one generated by the key generator
response.id === 'my-overridden-id';
```

## cached

- Type: `boolean`

A simple boolean indicating if the request returned data from the cache or from the
network call.

::: tip

This does not indicated if the request was capable of being cached or not, as options like
[`cache.override`](./request-specifics.md#cache-override) may have been enabled.

:::

## stale

- Type: `boolean`

A simple boolean indicating if the request returned data is from valid or stale cache.
