#!/bin/bash

# UPDATE BUILD FLAGS
case ${ARCH} in
x86-64 | x86-64-mac-catalyst)
  export CXX="xcrun --sdk $(get_sdk_name) clang++ -arch x86_64"
  ;;
arm64-simulator | arm64-mac-catalyst)
  export CXX="xcrun --sdk $(get_sdk_name) clang++ -arch arm64"
  ;;
*)
  export CXX="xcrun --sdk $(get_sdk_name) clang++ -arch ${ARCH}"
  ;;
esac

# ALWAYS CLEAN THE PREVIOUS BUILD
make distclean 2>/dev/null 1>/dev/null

# REGENERATE BUILD FILES IF NECESSARY OR REQUESTED
if [[ ! -f "${BASEDIR}"/src/"${LIB_NAME}"/configure ]] || [[ ${RECONF_opencore_amr} -eq 1 ]]; then
  autoreconf_library "${LIB_NAME}" 1>>"${BASEDIR}"/build.log 2>&1 || return 1
fi

./configure \
  --prefix="${LIB_INSTALL_PREFIX}" \
  --with-pic \
  --with-sysroot="${SDK_PATH}" \
  --enable-static \
  --disable-shared \
  --disable-fast-install \
  --disable-maintainer-mode \
  --host="${HOST}" || return 1

make -j$(get_cpu_count) || return 1

make install || return 1

# MANUALLY COPY PKG-CONFIG FILES
cp amrnb/*.pc "${INSTALL_PKG_CONFIG_DIR}" || return 1
