// src/cli.rs
use clap::{App, Arg};

pub fn parse_args() -> clap::ArgMatches<'static> {
    App::new("Rust Markdown Converter")
        .version("1.4")
        .author("Arnav")
        .about("Converts Markdown to HTML")
        .arg(Arg::with_name("input")
             .help("Input markdown file")
             .required(true)
             .index(1))
        .arg(Arg::with_name("output")
             .help("Output HTML file")
             .required(false)
             .index(2))
        .arg(Arg::with_name("theme")
             .help("CSS theme for the output. Available: default, dark, light, solarized_dark, solarized_light, gruvbox_dark, gruvbox_light")
             .takes_value(true)
             .default_value("default"))
        .arg(Arg::with_name("clipboard")
             .help("Output the generated HTML directly to the clipboard")
             .short("c")
             .long("clipboard")
             .takes_value(false))
        .arg(Arg::with_name("pdf")
             .help("Export the generated HTML to a PDF file")
             .short("p")
             .long("pdf")
             .takes_value(false))
        .arg(Arg::with_name("browser")
             .help("Preview the generated HTML in the default web browser")
             .short("b")
             .long("browser")
             .takes_value(false))
        .arg(Arg::with_name("css")
             .help("Path to an external CSS file to include in the output HTML")
             .takes_value(true)
             .long("css"))
        .arg(Arg::with_name("pdf_name")
             .help("Specify the output PDF file name")
             .takes_value(true)
             .short("n")
             .long("pdf-name"))
        .arg(Arg::with_name("epub")
             .help("Export the generated HTML to an EPUB file")
             .short("e")
             .long("epub")
             .takes_value(false))
        .arg(Arg::with_name("verbose")
             .help("Enable verbose output")
             .short("v")
             .long("verbose")
             .takes_value(false))
        .get_matches()
}