# Contributing to TextScribe

Thank you for considering contributing to TextScribe!

## Table of Contents

- [Contributing to TextScribe](#contributing-to-textscribe)
  - [Table of Contents](#table-of-contents)
  - [Code of Conduct](#code-of-conduct)
  - [Getting Started](#getting-started)
    - [For PR](#for-pr)
  - [Contributing Guidelines](#contributing-guidelines)
    - [Code Style](#code-style)
    - [Variable Names](#variable-names)
    - [Documentation](#documentation)
    - [Testing](#testing)
  - [Submitting a Pull Request](#submitting-a-pull-request)
  - [Spam and Invalid Contributions](#spam-and-invalid-contributions)
  - [Contact](#contact)

## Code of Conduct

Before you start contributing, please read and adhere to our [Code of Conduct](CODE_OF_CONDUCT.md). We expect all contributors to follow these guidelines to maintain a respectful and welcoming community.

## Getting Started

1. Rmember to read [code of conduct](./code_of_conduct).

### For PR

1. Fork the repository to your own GitHub account.
2. Clone your forked repository to your local machine.
3. Create a new branch for your work with a proper well defined name.
4. Make your changes and commit them with meaningful commit messages.
5. Open [PRs](https://github.com/arncv/TextScribe/pulls) to development branch (Remember to [Squash](https://docs.github.com/en/desktop/managing-commits/squashing-commits-in-github-desktop) before making a pr).
6. If the PR is in relation to an issue/feature then it must be referenced within the PR.

## Contributing Guidelines

### Code Style

- Follow consistent code style throughout the project.
- Use indentation with 4 spaces.
- Use clear and descriptive variable and function names.
- Comment your code where necessary to explain complex logic.

### Variable Names

- Use meaningful and descriptive variable names.
- Avoid single-letter variable names unless they are for loop counters.

### Documentation

- Ensure that your code is well-documented.
- Include comments to explain the purpose and usage of functions and classes.
- Update the [README.md](./README.md) file if your changes introduce new features or modify existing ones.

### Testing

- Write test cases for the code you contribute.
- Ensure that your code passes all existing tests.
- If you add new functionality, add corresponding tests.

## Submitting a Pull Request

1. Push your changes to your forked repository.
2. Create a pull request from your forked repository to the development branch of this repository on GitHub.
3. Ensure that your pull request includes a clear description of the changes made and their purpose.
4. Our team will review your pull request and provide feedback or merge it if everything looks good.

## Spam and Invalid Contributions

Spammy or invalid contributions will not be tolerated. We take the quality of our project seriously. If your contributions are identified as spam or invalid, they will be marked accordingly. Please ensure that your contributions align with our guidelines and benefit the project.

## Contact

If you have any questions or need further assistance, feel free to reach out to us.
