<div align="center">

<!-- title -->

<!--lint ignore no-dead-urls-->

# Awesome Krita [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) [![lint](https://github.com/armstrongl/awesome-krita/actions/workflows/lint.yaml/badge.svg)](https://github.com/armstrongl/awesome-krita/actions/workflows/lint.yaml)

<!-- subtitle -->

An awesome list of Krita resources.

<!-- image -->

<a href="https://krita.org/" target="_blank" rel="noopener noreferrer">
  <img src="https://static.wikia.nocookie.net/logopedia/images/7/73/Calligrakrita-base.svg/revision/latest/scale-to-width-down/200?cb=20190531021319" />
</a>

<!-- description -->

[Krita](https://krita.org/) is an open source cross-platform raster graphics editor geared towards 2D animations.

</div>

<!-- TOC -->

## Contents

- [Contents](#contents)
- [General](#general)
- [Brushes](#brushes)
- [Plugins](#plugins)
- [Textures and patterns](#textures-and-patterns)
- [Tutorials](#tutorials)
- [Courses](#courses)
- [YouTube channels](#youtube-channels)
- [Forums](#forums)
- [Miscellaneous](#miscellaneous)
- [Contributing](#contributing)
  - [Contributors](#contributors)

<!-- CONTENT -->

## General

_General and official resources for Krita_

- [Official Krita documentation](https://docs.krita.org/en/)
- [Official Krita resources](https://docs.krita.org/en/resources_page.html)

## Brushes

_Krita brushes and brush bundles_

- [Realistic Ballpoint Pen Brush](https://krita-artists.org/t/cheap-ballpoint-pen-brush/17170) - A single brush preset that mimics using a ballpoint pen.
- [Rotating light brushes](https://krita-artists.org/t/rotating-light-brushtips-wip/64930) - A WIP collection of animated RGBA brushtips that using a rotating light in Blender.
- [Human skin bundle](https://krita-artists.org/t/human-skin-bundle/40805) - A collection of brushes for drawing human skin textures.
- [Concept & Illustration Lite Bundle](https://krita-artists.org/t/concept-illustration-lite-bundle/52452) - A minimal brush bundle.
- [RGBA-Mix brush](https://krita-artists.org/t/rgba-mix-brush/52560) - A single brush that mixes colors.
- [Experimental Pencils and much more](https://krita-artists.org/t/experimental-pencils-and-much-more/2776) - A brush that mimics using grainy charcoal.
- [Leafy watercolor brush](https://krita-artists.org/t/leafy-watercolor-brush/50218) - A bundle of brushes for painting foliage in a watercolor-style.
- [Blenderz](https://krita-artists.org/t/blenderz/47888) - A bundle of brushes for blending with various grains.
- [Speedpaintings Brushes: Flat brushes](https://krita-artists.org/t/speedpaintings-brushes-flat-brushes/37184) - A bundle of four brushes by [David Revoy](https://www.davidrevoy.com/) for speed painting.
- [Krita 2023 brushes](https://www.davidrevoy.com/article953/krita-brushes-2023-01-bundle) - A bundle of brushes by [David Revoy](https://www.davidrevoy.com/).
- [Krita Brushkit 7](https://www.davidrevoy.com/article264/brushkit-v7-0) - A bundle of brushes by [David Revoy](https://www.davidrevoy.com/).
- [Krita mix-brushes](https://www.davidrevoy.com/article312/krita-mix-brushes-bundle) - A bundle of brushes by [David Revoy](https://www.davidrevoy.com/) for mixing colors.
- [Charcoal pencils](https://www.davidrevoy.com/article326/krita-brushes-charcoal-pencils) - A bundle of brushes by [David Revoy](https://www.davidrevoy.com/) that mimic charcoal pencils.
- [Gymnart’s Brush Bundle](https://krita-artists.org/t/gymnarts-brush-bundle/42571) - A bundle of brushes for painting foliage.
- [Water Color Brush SAI](https://krita-artists.org/t/water-color-brush-sai/34456) - A collection of watercolor brushes.
- [DayPaintStudio Favorite Brushes V2](https://krita-artists.org/t/daypaintstudio-favorite-brushes-v2/43320) - A collection of brushes from DayPaintStudio.
- [Paint and Blend](https://krita-artists.org/t/paint-and-blend-an-attempt-at-recreation-of-paint-and-blend-mypaint-brush/42980) - A brush that mimics the "Paint and Blend" brush in MyPaint.
- [Square brush alphas](https://krita-artists.org/t/square-brush-alphas/35839) - A collection of chiseled and square brushes.
- [Rakurri Brush Set](https://krita-artists.org/t/rakurri-brush-set-free-krita-brushes/3524) - A collection of miscellanous general-purpose brushes.
- [Ink Pen (CSP-like)](https://krita-artists.org/t/ink-pen-csp-like/47274) - A brush that mimics the Ink Pen brush in Clip Studio.
- [Expressive Inks](https://krita-artists.org/t/expressive-inks-bundle-brushes-for-krita-5/80411) -  A bundle of brushes that emulates non-traditional drawing tools, such as wooden reeds, small branches, etc.
- [Hair Brushes](https://krita-artists.org/t/hair-brushes-a-gift-for-christmas/80857) - A collection of brushes for drawing hair.
- [SK Sketching in Krita V1](https://krita-artists.org/t/sk-sketching-in-krita-v1/45795) - A bundle of brushes for sketching and doodling.
- [Small watercolor and lineart bundle](https://krita-artists.org/t/small-watercolor-and-lineart-bundle/39792) - A bundle of brushes for watercolor and line art.
- [Clooms Concept Art Environments Brushes Pack](https://krita-artists.org/t/clooms-concept-art-environments-brushes-pack/61458) - A collection of hand-drawn brushes for creating environments.
- [Bug Craftsmanship - Brush bundle](https://krita-artists.org/t/bug-craftsmanship-brush-bundle/81467) - A small collection of miscellanous brushes.
- [Brushes inspired by BRUSH RUSH](https://krita-artists.org/t/brushes-inspired-by-brush-rush/68201) - A collection of brushes inspired by Brush Rush.
- [Concept Art & Illustration Bundle](https://krita-artists.org/t/concept-art-illustration-bundle/7448) - A collection of brushes for concept art and general illustrations.
- [Nahum’s Ink pens (for manga)](https://krita-artists.org/t/nahums-ink-pens-for-manga/61073) - A bundle of brushes for drawing ink-pen style manga.
- [Set of Watercolor Brushes](https://krita-artists.org/t/set-of-watercolor-brushes/3944) - A collection of watercolor brushes.
- [Awez Flat Brushes](https://krita-artists.org/t/awez-flat-brushes/73620) - A bundle of six flap brushes.
- [Awez Basic Brushes](https://krita-artists.org/t/awez-basic-brushes/63645) - A bundle of baisc brushes.
- [Wavenwater Concept art traditional medium Beta](https://krita-artists.org/t/wavenwater-concept-art-traditional-medium-beta/60632) - A bundle of brushes that mimic standard drawing tools like Copic alcohol markers.
- [Venu Brush Pack](https://krita-artists.org/t/venu-brush-pack/72113) - A bundle of brushes mimicing ink pens.
- [AuraNed E-pencils](https://krita-artists.org/t/auraned-e-pencils/69254) - A bundle of brushes mimicing ink pens.
- [Brush Pack (280 Brush Patterns)](https://krita-artists.org/t/brush-pack-280-brush-patterns/65990) - A large bundle of brushes.
- [MDFM’s Everyday Brushes Bundle](https://krita-artists.org/t/mdfms-everyday-brushes-bundle/64142) - A collection of general-purpose brushes.
- [ED's Hair Brushes and Blenders](https://krita-artists.org/t/ed-free-hair-brushes-and-blenders/46808) - Contains 12 hairbrushes and blenders for digital hair painting.

## Plugins

_Plugins for Krita_

- [Pigment o plugin](https://github.com/EyeOdin/Pigment.O) - A Krita plugin that adds a full featured color picker that very customizable. Much better than the built in color dockers in krita.
- [UI Redesign plugin](https://github.com/veryprofessionaldodo/Krita-UI-Redesign) - A Krita plugin that changes the interface to feel less cluttered and more modern. Adds an option to have a collapsible Toolbox and Tool Options over the canvas.
- [Krita Ai Diffusion](https://github.com/Acly/krita-ai-diffusion) - A Krita plugin that adds a streamlined interface for generating images with AI. Inpaint and outpaint with optional text prompt, no tweaking required.
- [Auto Sd Paint Ext](https://github.com/Interpause/auto-sd-paint-ext) - A Krita plugin to add custom backend API for Krita Plugin & more
- [Krita Batch Exporter](https://github.com/GDQuest/krita-batch-exporter) - A Krita plugin to batch export layers and groups with maximum flexibility. Scale, trim, export multiple copies of your layers.
- [Shortcut Composer](https://github.com/wojtryb/Shortcut-Composer) - A Krita plugin for creating complex keyboard shortcuts.
- [Blenderlayer](https://github.com/Yuntokon/BlenderLayer) - A Krita plugin that allows you to stream 3D View from Blender into Krita, behaving like a normal layer: You can trace over it, change the blending mode and even apply layer styles!
- [Imagine_board](https://github.com/EyeOdin/imagine_board) - A Krita plugin for browsing images and creating image boards.
- [Defuser](https://github.com/internationalTD/defuser) - A Krita plugin for working with Stable Diffusion.
- [Tk Krita](https://github.com/diegogarciahuerta/tk-krita) - A Shotgun Toolkit Engine for Krita.
- [Pixel Borders](https://github.com/sGaps/pixel-borders) - A Krita plugin for pixel borders.
- [Krita Plugin Bashactions](https://github.com/juancarlospaco/krita-plugin-bashactions) - A Krita plugin to execute Bash commands and programs as Actions on your current Images from Krita.
- [Vscode Krita Plugin Generator](https://github.com/cg-cnu/vscode-krita-plugin-generator) - A Krita plugin to create Krita script templates from VSCode.
- [Oca Krita](https://github.com/RxLaboratory/OCA-Krita) - A Krita plugin to export animation keyframes from Krita to a JSON format + PNG.
- [Krita Leonardo Ai](https://github.com/rainu/krita-leonardo-ai) - A Krita plugin for the Leonardo.Ai.
- [Kritacustompreview](https://github.com/Rolodophone/KritaCustomPreview) - A Krita docker for displaying a custom preview of your image.
- [Krita Plugin Mdp](https://github.com/weeb-poly/krita-plugin-mdp) - A Krita plugin for importing MDIPACK.
- [Krita Bulk Actions](https://github.com/Larpon/krita-bulk-actions) - A Krita bulk action plugin to perform assigned actions on marked layers.
- [Rgb565preview](https://github.com/Kirbyrawr/RGB565Preview) - A Krita plugin that shows a preview in RGB565 of the document you are working on.
- [Krita Sneaky Visibility](https://github.com/LainFenrir/krita-sneaky-visibility) - A Krita plugin that lets you change layer visibility without adding to the undo stack (works for multiple layers at once).
- [KanvasBuddy - a Minimalist Toolbar](https://krita-artists.org/t/kanvasbuddy-a-minimalist-toolbar/549) - A Krita plugin that floats on top of the canvas  packed with enough features to let you spend as much time in Canvas-Only mode as possible.
- [Compact Brush Toggler](https://github.com/kaichi1342/CompactBrushToggler) - A Krita plugin that allows you to quickly toggle individual brush properties.
- [Tool tweeks](https://krita-artists.org/t/tool-tweeks/52353) -  A Krita plugin with a collection of tweeks for the tool options docker.
- [BuliCommander](https://krita-artists.org/t/bulicommander/11612) - A Krita plugin that mimics the [Midnight Commander](https://midnight-commander.org/) file explorer.
- [Label Box](https://krita-artists.org/t/label-box/44086) - A Krita plugin that adds a a box to set color labels to layers in the docker menu.
- [Resource and Docker Menus Plugin](https://krita-artists.org/t/resource-and-docker-menus-plugin/39813) - A Krita plugin that adds two new menus in the menu bar one for Resources and another for Dockers.
- [Reference Tabs Docker](https://invent.kde.org/freyalupen/reference-tabs-docker) - A Krita plugin that adds a docker for containing reference images in separate tabs, with basic view manipulation (zoom, pan, rotate, mirror).
- [Blender Layer](https://krita-artists.org/t/plugin-blender-layer-live-3d-view-in-krita/63394) - A Krita plugin that allows you to stream 3D View from Blender into Krita, behaving like a normal layer.
- [Palette Generator](https://github.com/kaichi1342/PaletteGenerator) - A Krita docker that generates color scheme palette  randomly or based of the selected scheme.   
- [Eraser Shift plugin](https://github.com/EyeOdin/Eraser_Shift) - A Krita plugin that adds shortcuts for brushes and erasers.
- [Better Color Cycler](https://krita-artists.org/t/plugin-better-color-cycler-improved-shortcuts-and-support-for-dial-accessories/64347) -  A Krita plugin with improved shortcuts and support for dial accessories.
- [ColorPlus](https://krita-artists.org/t/colorplus-a-plugin-to-simulate-watercolor-painting/48685) - A Krita plugin to simulate watercolor painting.
- [Oughtasave](https://krita-artists.org/t/oughtasave-plugin-an-autosave-replacement/54894) - A Krita plugin that replaces the default autosave feature.

## Textures and patterns

_Textures and patterns for Krita_

- [Paper & Canvas Textures](https://krita-artists.org/t/20-free-paper-canvas-textures/77155) - A collection of paper and canvas textures.
- [Raghu’s Seamless Patterns](https://git.emblik.studio/raghukamath/Handmade-textures) - A collection of hand-made seamless textures.
- [Metaballs](https://krita-artists.org/t/free-pattern-metaballs/72028) - A collection of metaball textures.

## Tutorials

_Krita turtorials, how-to's, and guides_

- [How I create stronger watercolor edges using GMIC](https://krita-artists.org/t/how-i-create-stronger-watercolor-edges-using-gmic/57427)
- [Learn how to remove background in Krita](https://krita-artists.org/t/learn-how-to-remove-background-in-krita/30838)
- [Overlay mode great for making fur](https://krita-artists.org/t/overlay-mode-great-for-making-fur/50503)
- [Quick Sharpening of blury sculpting layers (upscaling technique)](https://krita-artists.org/t/quick-sharpening-of-blury-sculpting-layers-upscaling-technique/51677)
- [Beginner Series For Krita - Including Donut Tutorial](https://krita-artists.org/t/beginner-series-for-krita-including-donut-tutorial/36552)
- [Shade selectors](https://krita-artists.org/t/shade-selectors/7848)
- [Achieve the “vibrance” color adjustinging effect](https://krita-artists.org/t/achieve-the-vibrance-color-adjustinging-effect/32521)
- [Installing brushes made easy](https://krita-artists.org/t/installing-brushes-made-easy/71019)
- [How to put a grid on your reference image which matches the grid on the canvas](https://krita-artists.org/t/how-to-put-a-grid-on-your-reference-image-which-matches-the-grid-on-the-canvas/70979)
- [How to blend or mix colors in Krita](https://krita-artists.org/t/how-to-blend-or-mix-colors-in-krita/69515)

## Courses

_Krita courses_

- [Simón Sanchez’ “Learn to Create Pixel Art from Zero” course on Udemy](https://www.udemy.com/learn-to-create-pixel-art-from-zero/?couponCode=OTHER_75)

## YouTube channels

_YouTube channels that make Krita-related content_

- [David Revoy](https://www.youtube.com/channel/UCnAbNwJjusY7zQ__sQyJlSA) - David Revoy's YouTube channel.
## Forums

_Forums for Krita artists_

- [Krita Artists Forum](https://krita-artists.org/) - A forum for Krita artists to share tips, tricks, and resouces.
- [r/krita](https://www.reddit.com/r/krita/) - The Krita subreddit.
- [Art Mastodon](https://mastodon.art/about) - An inclusive community for artists of all kinds.

## Miscellaneous

_Other miscellaneous resources for Krita (e.g., palettes, themes, references, third-party tools, etc.)_

- [Zoldyako's Themes for Krita](https://github.com/Zoldyako/Zoldyako-Krita-Themes) - A collection of custom Krita themes.
- [BeeRef Reference Image Viewer](https://beeref.org/) - BeeRef lets you quickly arrange your reference images and view them  while you create. Its minimal interface is designed not to get in the  way of your creative process.
- [Radial Menu (on-screen Wacom type)](http://radialmenu.weebly.com/) - A small project to emulate the radial menu that Wacom distributes with some of their products but with per application menus.
- [Pencil & Charcoal Palette](https://krita-artists.org/t/pencil-charcoal-palette/58893) - A palette of common charcoal colors.
- [Story Board Template for Krita](https://lewisfullerhill.gumroad.com/l/PtMtm) - A filly editable story board layout that comes with a layering system and a vector template.


<!-- END CONTENT -->


## Contributing

[Contributions of any kind welcome, just follow the guidelines](contributing.md)!

### Contributors

[Thanks goes to these contributors](https://github.com/armstrongl/awesome-krita/graphs/contributors)!
