# Contributing to EmbedPG

Thank you for your interest in contributing to EmbedPG! We welcome contributions from the community and are grateful for your help.

## How to Contribute

1. **Fork the Repository**: Start by forking the EmbedPG repository to your GitHub account.

2. **Clone Your Fork**: Clone your forked repository to your local machine.

    ```sh
    git clone https://github.com/your-username/embed-pg.git
    ```

3. **Create a Branch**: Create a new branch for your changes. Use a descriptive name for your branch.

    ```sh
    git checkout -b feature/your-feature-name
    ```

4. **Make Your Changes**: Make the necessary changes in your local repository.

5. **Commit Your Changes**: Commit your changes with a descriptive commit message.

    ```sh
    git add .
    git commit -m "Description of your changes"
    ```

6. **Push to Your Fork**: Push your changes to your forked repository on GitHub.

    ```sh
    git push origin feature/your-feature-name
    ```

7. **Open a Pull Request**: Open a pull request to the main repository. Describe your changes and why they should be merged.

## Guidelines

- **Code Quality**: Ensure your code follows best practices and is well-documented.
- **Tests**: Write tests for your code to ensure it works as expected.
- **Commit Messages**: Write clear and concise commit messages.
- **Pull Request Description**: Provide a detailed description of your changes in the pull request.
