# Code of Conduct

All members, committers and volunteers in this project are required to act according to the following Code of Conduct. We ask you to follow these guidelines which help steer our interactions and strive to keep _styled-modern-normalize_ a positive and growing project and help us provide and ensure a safe environment for everyone.

If you are being harassed, notice that someone else is being harassed, or have any other concerns, please contact one of the core team members via [email][]. Your reports will be taken seriously and not dismissed or argued with.

## What we believe in and how we act

* In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to make participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation. We welcome people regardless of these or other attributes.
* Our community is based on mutual respect, tolerance, and encouragement.
* We believe that a diverse community where people treat each other with respect is stronger, more vibrant and has more potential contributors and more sources for ideas. We aim for more diversity.
* We are kind, welcoming and courteous to everyone.
* We are respectful of others, their positions, their skills, their commitments and their efforts.
* We are attentive in our communications, whether in person or online, and we are tactful and respectful when approaching differing views and experiences.
* We are aware that language shapes reality. Thus, we use inclusive, gender-neutral language in the documents we provide and when we talk to people. When referring to a group of people, we aim to use gender-neutral terms like "team", "folks" or "everyone". <sup>[1][ref-gender-neutral-docs]</sup>
* We respect that people have differences of opinion and criticize constructively.

## Unacceptable Behavior

* Do not be mean or rude.
* Do not discriminate against anyone.
* Sexism and racism of any kind (including sexist and racist "jokes"), demeaning or insulting behaviour and harassment are seen as direct violations to this Code of Conduct. Harassment includes offensive verbal comments related to age, body size, culture, ethnicity, gender expression, gender identity, level of experience, nationality, personal ability or disability, physical appearance, physical or mental difference, race, religion, set of skills, sexual orientation, socio-economic status, and subculture. Harassment also includes sexual images in public spaces, deliberate intimidation, stalking, following, harassing photography or recording, inappropriate physical contact, and unwelcome sexual attention.
* Respect that some individuals and cultures consider the casual use of profanity offensive and off-putting.
* Derailing, tone arguments and otherwise playing on people's desires to be nice are not welcome, especially in discussions about violations to this Code of Conduct.
* Please avoid unstructured critique.
* Likewise any spamming, trolling, flaming, baiting or other attention-stealing behaviour is not welcome.
* Publishing others' private information, such as a physical or electronic address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Responsibilities

The members of the core team and project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project core team members or owner via [email][]. The project team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## Consequences for Violations

If a participant engages in any behaviour violating this Code of Conduct, the core team members and project owner of this project may take any action they deem appropriate, including warning the offender or expulsion from the project, exclusion from any interaction and loss of all rights in this project.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

Decisions about consequences of violations of this Code of Conduct are made by this projects core team members and project owner as named above and will not be discussed with the person responsible for the violation.

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

---

Thanks for the inspirations and attributions to GitHub's [Open Source Guides](https://opensource.guide), [Hoodie's Code of Conduct](http://hood.ie/code-of-conduct) and the [Contributor Covenant Version 1.4](http://contributor-covenant.org/version/1/4/).

[email]: https://github.com/arcticicestudio/styled-modern-normalize/blob/develop/.mailmap
[ref-gender-neutral-docs]: https://modelviewculture.com/pieces/gendered-language-feature-or-bug-in-software-documentation
