<!-- Click on the "Preview" tab to render the instructions in a more readable format -->

> **Please read the [contribution guidelines](https://github.com/arcticicestudio/styled-modern-normalize/blob/develop/CONTRIBUTING.md) before filling out this pull request template**.

## Prerequisites

This section and the instructions in the sections below are only part of this pull request template. Please ensure to **delete this whole section, all pre-filled instructions of the sections below and sections you have not filled out before submitting** to ensure a clear structure and overview.

Please do your best to provide as much information as possible and use a clear and descriptive title for your enhancement suggestion or bug fix to help maintainers and the community understand and reproduce the behavior, find related pull requests and to merge it faster.

* **Ensure the pull request has not already been reported by using the [GitHub Pull Request search](https://github.com/arcticicestudio/styled-modern-normalize/pulls)** — if it has **and the pull request is still open**, add a comment to the existing pull request instead of opening this new one. If you find a closed pull request that seems to be similar to this one, include a link to it in the [metadata head](#metadata-head) section of this pull request.
* **Ensure the contribution belongs to the [correct repository](https://github.com/arcticicestudio?tab=repositories&q=styled-modern-normalize).**
* **Ensure to adhere to the [pull request contribution guidelines](https://github.com/arcticicestudio/styled-modern-normalize/blob/develop/CONTRIBUTING.md#pull-requests)**, especially the one for tests and documentations.

## Metadata Head

The metadata head should be added to the top of the pull request as [Markdown text quote](https://help.github.com/articles/basic-writing-and-formatting-syntax) containing the [GitHub issue keyword(s)](https://help.github.com/articles/closing-issues-using-keywords) to link to the related enhancements suggestions (`Closes`) or bug reports (`Fixes`). You can add additional details like dependencies to other pull requests and the order it needs to be merged.

> Closes/Fixes ISSUE_ID  
> Must be merged **after**/**before** ISSUE_ID  
> Blocked by ISSUE_ID

## Description

Describe the changes as in many relevant details as possible. If this is a enhancement suggestion add specific use-cases and explain why this feature or improvement would be useful. If this is a bug fix ensure to provide a _before/after_ comparison by describing the current behavior and the new behavior.

## References

Add any other references and links which are relevant for this issue.
