---

name: Enhancement Suggestions
about: Submit an enhancement suggestion for new features or minor improvements to existing functionality

---

<!-- Click on the "Preview" tab to render the instructions in a more readable format -->

> **Please read the [contribution guidelines](https://github.com/arcticicestudio/styled-modern-normalize/blob/develop/CONTRIBUTING.md) before filling out this issue template**.

## Prerequisites

This section and the instructions in the sections below are only part of this issue template. Please ensure to **delete this whole section, all pre-filled instructions of the sections below and sections you have not filled out before submitting** to ensure a clear structure and overview.

Please do your best to provide as much information as possible and use a clear and descriptive title for your enhancement suggestion to help maintainers and the community understand and reproduce the behavior, find related reports and to resolve the ticket faster.

* **Ensure the issue has not already been reported by using the [GitHub Issues search](https://github.com/arcticicestudio/styled-modern-normalize/issues)** — if it has **and the issue is still open**, add a comment to the existing issue instead of opening this new one. If you find a closed issue that seems to be similar to this one, include a link to the original issue in the [metadata head](#metadata-head) section of this issue.
* **Ensure the contribution belongs to the [correct repository](https://github.com/arcticicestudio?tab=repositories&q=styled-modern-normalize).**
* If your feature request
* **Ensure the issue is reproducible** — try to use the [latest version](https://github.com/arcticicestudio/styled-modern-normalize/releases/latest) and [`develop`](https://github.com/arcticicestudio/styled-modern-normalize/tree/develop) branch.

## Metadata Head

The metadata head can be added to the top of the issue as [Markdown text quote](https://help.github.com/articles/basic-writing-and-formatting-syntax) containing the ID of other related issues or additional details like dependencies to other issues/pull requests and the order it needs to be processed.

> Related issues:  
> Must be processed **after**/**before** ISSUE_ID  
> Blocked by ISSUE_ID

## Description

Describe the enhancement in many relevant details as possible.

### Benefits

Add specific use-cases and explain why this feature or improvement would be useful and maybe include references to related known problems or bug reports.

### Possible Drawbacks

Describe possible negative impacts regarding e.g. functionality or usability.

### Alternative Solutions

If you've considered alternative features or solutions please describe it clearly and concise.

## Example

Provide a [MCVE - The Minimal, Complete, and Verifiable Example](https://github.com/arcticicestudio/styled-modern-normalize/blob/develop/CONTRIBUTING.md#mcve)

This is a **optional section, but it can drastically increase the speed at which this issue can be processed** since it takes away the **time-consuming reconstruction** to reproduce the enhancement.

The recommended way is to upload it as [Gist](https://gist.github.com) or new repository to GitHub, but of course you can [attach it to this issue](https://help.github.com/articles/file-attachments-on-issues-and-pull-requests), use any free file hosting service or paste the code in [Markdown code blocks](https://help.github.com/articles/basic-writing-and-formatting-syntax) into this issue.

## Additional Context

Add any other context, screenshots or screencasts which are relevant for this issue.

## References

Add any other references and links which are relevant for this issue.

## Potential Solution

Maybe include references to other projects where this enhancement already exists.
