---
title: Elasticsearch domain isn't encrypted at rest.
shortcode: enable-domain-encryption
summary: Elasticsearch domain isn't encrypted at rest. 
permalink: /docs/elastic-search/enable-domain-encryption/
---

### Explanation

You should ensure your Elasticsearch data is encrypted at rest to help prevent sensitive information from being read by unauthorised users.

### Possible Impact
Data will be readable if compromised

### Suggested Resolution
Enable ElasticSearch domain encryption


### Insecure Example

The following example will fail the AVD-AWS-0048 check.

```yaml
---
Resources:
  BadExample:
    Type: AWS::Elasticsearch::Domain
    Properties:
      DomainName: 'test'
      ElasticsearchVersion: '7.10'
      ElasticsearchClusterConfig:
        DedicatedMasterEnabled: true
        InstanceCount: '2'
        ZoneAwarenessEnabled: true
        InstanceType: 'm3.medium.elasticsearch'
        DedicatedMasterType: 'm3.medium.elasticsearch'
        DedicatedMasterCount: '3'
      EBSOptions:
        EBSEnabled: true
        Iops: '0'
        VolumeSize: '20'
        VolumeType: 'gp2'

```



### Secure Example

The following example will pass the AVD-AWS-0048 check.

```yaml
---
Resources:
  GoodExample:
    Type: AWS::Elasticsearch::Domain
    Properties:
      DomainName: 'test'
      ElasticsearchVersion: '7.10'
      EncryptionAtRestOptions:
        Enabled: true
        KmsKeyId: alias/kmskey
      ElasticsearchClusterConfig:
        DedicatedMasterEnabled: true
        InstanceCount: '2'
        ZoneAwarenessEnabled: true
        InstanceType: 'm3.medium.elasticsearch'
        DedicatedMasterType: 'm3.medium.elasticsearch'
        DedicatedMasterCount: '3'
      EBSOptions:
        EBSEnabled: true
        Iops: '0'
        VolumeSize: '20'
        VolumeType: 'gp2'

```




### Related Links


- [https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/encryption-at-rest.html](https://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/encryption-at-rest.html)


