-- 表结构: aphp_config --
CREATE TABLE `aphp_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '名称',
  `config_key` varchar(20) NOT NULL DEFAULT '' COMMENT '键名',
  `config_value` varchar(255) NOT NULL DEFAULT '' COMMENT '键值',
  `config_type` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '类型',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COMMENT='配置表';
-- <fen> --
-- 表结构: aphp_doc --
CREATE TABLE `aphp_doc` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '标题',
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '名称',
  `summary` varchar(200) NOT NULL DEFAULT '' COMMENT '简介',
  `thumb` varchar(200) NOT NULL DEFAULT '' COMMENT '封面',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建者ID',
  `author` varchar(20) NOT NULL DEFAULT '' COMMENT '创建者',
  `sort` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `is_top` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否置顶',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COMMENT='文档表';
-- <fen> --
-- 表结构: aphp_doc_data --
CREATE TABLE `aphp_doc_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `doc_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '文档ID',
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '名称',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `markdown` text NOT NULL COMMENT '内容',
  `sort` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新者ID',
  `author` varchar(20) NOT NULL DEFAULT '' COMMENT '最后更新',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='文档数据表';
-- <fen> --
-- 表结构: aphp_single --
CREATE TABLE `aphp_single` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `sign` varchar(16) NOT NULL DEFAULT '' COMMENT '标识',
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '名称',
  `title` varchar(100) NOT NULL DEFAULT '' COMMENT '标题',
  `summary` varchar(255) NOT NULL DEFAULT '' COMMENT '摘要',
  `thumb` varchar(255) NOT NULL DEFAULT '' COMMENT '封面',
  `content` text NOT NULL COMMENT '内容',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COMMENT='单页表';
-- <fen> --
-- 表结构: aphp_user --
CREATE TABLE `aphp_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `username` varchar(20) NOT NULL DEFAULT '' COMMENT '用户',
  `password` varchar(32) NOT NULL DEFAULT '' COMMENT '密码',
  `nickname` varchar(20) NOT NULL DEFAULT '' COMMENT '昵称',
  `email` varchar(100) NOT NULL DEFAULT '' COMMENT '邮箱',
  `mobile` char(11) NOT NULL DEFAULT '' COMMENT '手机号',
  `qq` varchar(20) NOT NULL DEFAULT '' COMMENT 'QQ号',
  `bio` varchar(120) NOT NULL DEFAULT '' COMMENT '格言',
  `avatar` varchar(100) NOT NULL DEFAULT '' COMMENT '头像',
  `level` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '等级',
  `money` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '余额',
  `score` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '积分',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COMMENT='用户表';
-- <fen> --
