<?php
declare(strict_types=1);
namespace app\index\model;
use aphp\core\Model;
class DocData extends Model
{
	protected string $table = 'doc_data';
	protected string $pk = 'id';
    protected array $validate = [
        ['title', 'required', '目录标题必须', AT_MUST, IN_BOTH],
        ['name', 'string|unique', '文件名称必须英文|名称已存在', AT_MUST, IN_BOTH],
        ['markdown', 'required', '内容必须', AT_MUST, IN_BOTH],
        ['sort', 'number', '排序值必须是数字', AT_MUST, IN_BOTH],
    ];
    protected array $auto = [
        ['status', '1', 'string', AT_MUST, IN_INSERT]
    ];

    protected function _validate_map(array $data = []): array
    {
        return ['doc_id' => $data['doc_id']];
    }

    protected function _before_insert(array &$data): void
    {
        $data['user_id'] = session('user.id');
        $data['author'] = session('user.nickname');
    }

    protected function _before_update(array &$data): void
    {
        $data['user_id'] = session('user.id');
        $data['author'] = session('user.nickname');
    }
}