<?php
declare(strict_types=1);
namespace app\index\model;
use aphp\core\Model;
class Doc extends Model
{
	protected string $table = 'doc';
	protected string $pk = 'id';
    protected array $validate = [
        ['level', 'number', '请选择文档类型', AT_MUST, IN_BOTH],
        ['title', 'required|unique', '标题必须|标题已存在', AT_MUST, IN_BOTH],
        ['name', 'string|unique', '文件名称必须英文|名称已存在', AT_MUST, IN_BOTH],
        ['summary', 'required', '简介必须', AT_MUST, IN_BOTH],
        ['sort', 'number', '排序值必须是数字', AT_MUST, IN_BOTH],
    ];
    protected array $auto = [
        ['status', '1', 'string', AT_MUST, IN_INSERT]
    ];

    protected function _before_insert(array &$data): void
    {
        $data['user_id'] = session('user.id');
        $data['author'] = session('user.nickname');
    }

    protected function _after_insert(array $data): void
    {
        $origin = [];
        $origin['doc_id'] = $data['id'];
        $origin['name'] = 'about';
        $origin['title'] = '关于';
        $origin['markdown'] = "## 关于 \n\n欢迎使用".$data['title'];
        $origin['sort'] = 1;
		$origin['user_id'] = $data['user_id'];
        $origin['author'] = $data['author'];
        $origin['update_time'] = time();
        $origin['status'] = 1;
        db('doc_data')->insert($origin);
    }

    protected function _after_delete(array $data): void
    {
        db('doc_data')->where('doc_id', $data['id'])->delete();
    }
}