<?php
declare(strict_types=1);
namespace app\index\controller;
use aphp\core\Jump;
class Profile
{
    use Jump;
    protected string $middleware = 'check_login'; //登录验证

    //个人中心
    public function index()
    {
        $user = model('user')->find(session('user.id'));
        return view()->with(['vo' => $user->toArray()]);
    }

    //修改资料
    public function edit(array $req)
    {
        $user = model('user')->find(session('user.id'));
        if ($this->isPost()) {
            $r = $user->save($req);
            $this->_jump(['修改成功', '修改失败'], $r, 'index');
        }
        return view()->with('vo', $user->toArray());
    }

    //修改密码
    public function password(array $req)
    {
        if ($this->isPost()) {
            $user = model('user');
            $r = $user->changePwd($req);
            $this->_jump(['修改成功', $user->getError()], $r, 'index');
        }
        return view();
    }
}