<?php
declare(strict_types=1);
namespace app\index\controller;
use aphp\core\Jump;
use aphp\core\Tool;

class Md
{
    use Jump;

    protected array $middleware = [
        'check_login' => ['except' => ['index', 'down']],
    ];

    // 查看
    public function index(int $id)
    {
        $vo = widget('doc_data')->get($id);
        if (!$vo) {
            $this->error('此文档暂无内容');
        }
        return view()->with(['vo' => $vo, 'doc_id' => $vo['doc_id']]);
    }

    // 下载单个文档
    public function down(int $id)
    {
        $vo = widget('doc_data')->get($id);
        if (!$vo) {
            $this->error('此文档不存在');
        }
        // 初始化目录
        $doc_name = db('doc')->where('id', $vo['doc_id'])->value('name'); // 文档名称
        $dir = ROOT_PATH . '/public/doc/' . $doc_name; // 文档目录
        if (!is_dir($dir)) {
            Tool::dir_init($dir, 0777);
        }
        // 页脚
        $footer = "\n\n>本文档由 [APHP文档系统](https://doc.aphp.top) 生成，文档更新于：" . date('Y-m-d H:i:s', $vo['update_time']);
        // 获取排序值
        $data = widget('doc_dir')->get($vo['doc_id']);
        $keys = array_keys($data);
        $k = array_search($id, $keys) + 1;
        $k = str_pad(strval($k), 2, '0', STR_PAD_LEFT);
        // 生成文件
        $file = $dir . '/_' . $k . '_' . $vo['name'] . '.md'; // 文件路径
        if (file_exists($file)) {
            unlink($file);
        }
        file_put_contents($file, $vo['markdown'] . $footer); //生成文件
        $url = str_replace(ROOT_PATH . '/public', __URL__, $file); //文件url地址
        $this->_url($url); //跳转文件
    }

    // 验证权限
    protected function _check_author(int $doc_id)
    {
        $author_id = db('doc')->where('id', $doc_id)->value('user_id');
        if ($author_id != session('user.id') || session('user.level') < 2) {
            $this->error('不是文档归属者或会员等级不足');
        }
    }

    // 新增
    public function add(int $doc_id, array $req)
    {
        $this->_check_author($doc_id); // 验证权限
        if ($this->isPost()) {
            $r = pdo()->trans(function () use ($req) {
                model('doc_data')->save($req);
            });
            $this->_jump(['添加成功', '添加失败'], $r, 'md/index?id=' . get_start_id($doc_id));
        }
        return view()->with('doc_id', $doc_id);
    }

    // 修改
    public function edit(int $id, array $req)
    {
        $model = model('doc_data')->find($id);
        if (!$model) {
            $this->error('记录不存在');
        }
        $vo = $model->toArray();
        $this->_check_author($vo['doc_id']); // 验证权限
        if ($this->isPost()) {
            $r = pdo()->trans(function () use ($model, $req) {
                $model->save($req);
            });
            $this->_jump(['修改成功', '修改失败'], $r, 'md/index?id=' . $id);
        }
        return view()->with(['vo' => $vo, 'doc_id' => $vo['doc_id']]);
    }

    // 删除
    public function del(int $id)
    {
        if ($this->isAjax()) {
            $model = model('doc_data')->find($id);
            if (!$model) {
                $this->error('记录不存在');
            }
            $vo = $model->toArray();
            $this->_check_author($vo['doc_id']); // 验证权限
            $r = $model->del();
            $this->_jump(['删除成功', '删除失败'], $r, 'md/index?id=' . get_start_id($vo['doc_id']));
        }
        $this->error('非法操作');
    }
}