<?php
declare(strict_types=1);
namespace app\index\controller;
use aphp\core\Jump;
use aphp\core\Tool;

class Doc
{
    use Jump;
    protected array $middleware = [
        'check_login' => ['except' => ['down']], //除下载外
    ];

    // 检测权限
    protected function _check_level(int $level = 1)
    {
        if ((int)session('user.level') < $level) {
            $this->error('会员等级不足', 403);
        }
    }

    // 添加
    public function add(array $req)
    {
        $this->_check_level(2); // 检测权限
        if ($this->isPost()) {
            $r = pdo()->trans(function () use ($req) {
                model('doc')->save($req);
            });
            $this->_jump(['添加成功', '添加失败'], $r, 'profile/index');
        }
        return view();
    }

    // 修改
    public function edit(int $id, array $req)
    {
        $this->_check_level(2); // 检测权限
        $model = model('doc')->find($id);
        if (!$model) {
            $this->error('记录不存在');
        }
        $vo = $model->toArray();
        if ($vo['user_id'] != session('user.id')) {
            $this->error('', 401);
        }
        if ($this->isPost()) {
            $r = pdo()->trans(function () use ($model, $req) {
                $model->save($req);
            });
            $this->_jump(['修改成功', '修改失败'], $r, 'profile/index');
        }
        return view()->with(['vo' => $vo]);
    }

    // 删除
    public function del(int $id)
    {
        $this->_check_level(2); // 检测权限
        if ($this->isAjax()) {
            $model = model('doc')->find($id);
            if (!$model) {
                $this->error('记录不存在');
            }
            $vo = $model->toArray();
            if ($vo['status'] != 0) {
                $this->error('请先停用后再删除');
            }
            if ($vo['user_id'] != session('user.id')) {
                $this->error('', 401);
            }
            $r = $model->del();
            $this->_jump(['删除成功', '删除失败'], $r, 'profile/index');
        }
        $this->error('非法操作');
    }

    // 下载整体文档
    public function down(int $id)
    {
        // 初始化目录
        $doc_name = db('doc')->where('id', $id)->value('name'); // 文档名称
        $dir = ROOT_PATH.'/public/doc/'.$doc_name; // 文档目录
        if (is_dir($dir)) {
            Tool::dir_delete($dir);
        } else {
            Tool::dir_init($dir, 0777);
        }
        // 页脚
        $footer = "\n\n>本文档由 [APHP文档系统](https://doc.aphp.top) 生成，文档更新于：";
        // 生成文档文件到目录
        $list = db('doc_data')->field('id,doc_id,name,markdown,update_time')->where('doc_id', $id)->where('status=1')->order('sort ASC,id ASC')->select();
        foreach ($list as $k => $vo) {
            $k ++;
            $k = str_pad(strval($k), 2, '0', STR_PAD_LEFT);
            $footer .= date('Y-m-d H:i:s', $vo['update_time']);
            file_put_contents($dir.'/_'.$k.'_'.$vo['name'].'.md', $vo['markdown'].$footer);
        }
        // 下载目录压缩包
        $zipFile = $dir . '.zip';
        if (file_exists($zipFile)) {
            unlink($zipFile);
        }
        $zip = new \PharData($zipFile);
        $zip->buildFromDirectory($dir, '/\.md$/');
        if (!is_file($zipFile)) {
            $this->error('文档文件不存在');
        }
        if (ob_get_length() !== false) @ob_end_clean();
        header('Content-Type: application/zip');
        header('Content-Disposition:attachment;filename=doc_' . $doc_name . '.zip');
        header('Content-Length:' . filesize($zipFile));
        @readfile($zipFile);
        @unlink($zipFile);
        exit;
    }
}