<?php
declare(strict_types=1);
namespace app\index\controller;
use aphp\core\Jump;
use extend\upload\Upload;

class Api
{
	use Jump;

    // 清除缓存
    public function clear()
    {
        cache_clear();
        cli('clear:runtime index');
        $this->success('清除缓存成功', 'index/index');
    }

    // 编辑器上传
    public function editor_md_upload(): array
    {
        $res = Upload::init('img')->save();
        $ajax = ['success' => 0, 'message' => '上传失败', 'url' => ''];
        if (isset($res[0]['path'])) {
            $ajax = ['success' => 1, 'message' => '上传成功', 'url' => __HOST__.$res[0]['path']];
        }
        return $ajax;
    }

    // 图片base64上传
    public function upload_base64()
    {
        $type = input('post.type', '', 'clear_html');
        $base64 = input('post.base64');
        $res = Upload::init($type)->saveBase64($base64);
        if (!$res['path']) {
            $this->error('上传失败');
        }
        $this->_json(200, '上传成功', ['path' => $res['path']]);
    }

    // 图片删除
    public function image_del() {
        $pic = input('post.pic', '', 'clear_html');
        $filename = trim($pic, '.');
        $file = ROOT_PATH.'/public'.$filename;
        if (file_exists($file)) {
            unlink($file);
        }
        $this->success('删除成功');
    }
}