<?php
declare(strict_types=1);

// 获取等级
function get_level(int $lv = -1)
{
    $levels = parse_config(site('user_level', '1=会员|编辑|后台'));
    return $levels[$lv] ?? $levels;
}

// 配置处理
function parse_config(string $str, string $sep = '|', string $eq = '=')
{
    if (!str_contains($str, $sep)) {
        return $str;
    }
    $is_key = str_contains($str, $eq); // 是否有主键
    $str = array_diff(explode($sep, $str), ['']); // 删除空值
    if (!$is_key) {
        return $str;
    }
    $arr = [];
    $i = 0;
    foreach ($str as $k => $v) {
        if (str_contains($v, $eq)) {
            [$i, $v] = explode($eq, $v);
        } elseif ($k != 0) {
            $i ++;
        }
        if (isset($arr[$i])) $i ++;
        $arr[$i] = trim($v);
    }
    return $arr;
}

//获取上下篇
function get_related(int $id, int $doc_id): array
{
    $data = widget('doc_dir')->get($doc_id);
    $keys = array_keys($data);
    $k = array_search($id, $keys);
    $prev_id = $keys[$k-1] ?? 0;
    $next_id = $keys[$k+1] ?? 0;
    $prev = $prev_id ? ['id' => $prev_id, 'title' => $data[$prev_id]] : [];
    $next = $next_id ? ['id' => $next_id, 'title' => $data[$next_id]] : [];
    return ['prev' => $prev, 'next' => $next];
}

// ids过滤转换
function ids_filter(string $ids, bool $to_array = false, bool $gt_0 = true)
{
    $ids = array_filter(explode(',', $ids), 'is_numeric');
    $ids = array_unique($ids);
    if ($gt_0) {
        $ids = array_filter($ids, fn(int $n)=>$n>0);
    }
    ksort($ids);
    return $to_array ? $ids : implode(',', $ids);
}

// 表名验证
function is_table(string $table): bool
{
    $prefix = pdo()->getConfig('table_prefix');
    return (bool)preg_match('/^' . $prefix . '\w{1,12}$/', $table);
}

// 导航高亮显示
function nav_active(string $nav, string $class = ' class="active"'): string
{
    return ($nav == get_controller()) ? $class : '';
}

// 格式时间
function get_time_ago(int $time): string
{
    $etime = time() - $time;
    if ($etime < 1) {
        return '刚刚';
    }
    $interval = [31536000 => '年前', 2592000 => '个月前', 604800=>'星期前', 86400=>'天前', 3600=>'小时前', 60=>'分钟前', 1=>'秒前'];
    foreach ($interval as $k => $v) {
        $ok = floor($etime / $k);
        if ($ok != 0) {
            return $ok.$v;
        }
    }
    return '刚刚';
}

// 生成form:select
function build_select(string $name, $options, $selected = ''): string
{
    $options = is_array($options)? $options : explode(',', $options);
    $html = "<select name=\"{$name}\" class=\"form-control\" style=\"width:auto;\">\n";
    foreach ($options as $val => $key) {
        if ($selected == $val) {
            $html .= "\t<option value=\"{$val}\" selected=\"selected\">{$key}</option>\n";
        } else {
            $html .= "\t<option value=\"{$val}\">{$key}</option>\n";
        }
    }
    $html .= "</select>\n";
    return $html;
}

// 生成form:radios
function build_radios(string $name, $options, $selected = ''): string
{
    $options = is_array($options)? $options : explode(',', $options);
    $html = '';
    foreach ($options as $val => $key) {
        if ($selected == $val) {
            $html .= "<label><input type=\"radio\" name=\"{$name}\" value=\"{$val}\" checked=\"checked\" />{$key}</label>\n";
        } else {
            $html .= "<label><input type=\"radio\" name=\"{$name}\" value=\"{$val}\" />{$key}</label>\n";
        }
    }
    return $html;
}

// 获取文档起启页ID
function get_start_id(int $doc_id): int
{
    $doc = widget('doc_dir')->get($doc_id);
    if (!empty($doc)) {
        return array_key_first($doc);
    }
    return 0;
}

//获取缩略图
function aphp_thumb(string $url, int $i):string
{
    if ($i>40) {
        $i = $i % 40;
    }
    return !empty($url)? $url : __STATIC__.'/img/thumb/'.$i.'.jpg';
}
