## 一鱼文档系统

多用户markdown文档管理，使用editormd编辑器，可制作开发手册，教程文档，学习笔记等。

### 功能简介

- [前台]用户：注册，登录，修改资料，修改密码
- [前台]文档：查看，下载，添加，修改，删除
- [前台]文档内容：查看，下载，添加，修改，删除
- [后台]文档管理：添加，修改，删除，启用，停用
- [后台]用户管理：添加，修改，删除，启用，停用
- [后台]网站配置：添加，修改，删除，生成配置文件
- [后台]数据管理：备份数据表，查看表结构，优化，修复数据表
- [后台]备份管理：还原数据，下载，删除备份

### 演示地址

https://doc.aphp.top

## 更新日志

#### v1.2 2024-06-15

- 修复：自动添加的第一篇文档无权限的问题

#### v1.1 2024-06-14

- 新增：用户注册功能
- 权限：编辑v2以上才能发布管理文档
- 新增：上一篇和下一篇功能

#### 安装指南

1. 上传并解压安装包到网站目录
2. 设置-网站目录-运行目录到`/public`
3. 设置-伪静态规则(看`url_rewrite.txt`)
4. 修改`config/database.php`中数据库配置
5. 访问并输入`backup`目录下的备份文件名进行安装

### 伪静态设置

Nginx规则：

```
location / {
	if (!-e $request_filename) {
		rewrite  ^(.*)$  /index.php/$1  last;
	}
}
```

Apache规则：

```
<IfModule mod_rewrite.c>
  Options +FollowSymlinks -Multiviews
  RewriteEngine On
  RewriteCond %{REQUEST_FILENAME} !-d
  RewriteCond %{REQUEST_FILENAME} !-f
  RewriteRule ^(.*)$ index.php? [L,E=PATH_INFO:$1]
</IfModule>
```

### 技术支持

QQ群1：325825297  QQ群2：16008861

官网：[aphp.top](https://www.aphp.top) 作者：大松栩(24203741@qq.com) 